from django.contrib import admin
from models import *

class AbstractSubmissionAdmin(admin.ModelAdmin):
    list_display = ('given_name','surname','abstract_request','content_type','status','abstract_category')
    list_filter = ['content_type','abstract_category']

class AbstractSubmissionFileAdmin(admin.ModelAdmin):
    list_display = ('content_submission','file')
    list_filter = ['content_submission']
    
class AbstractSubmissionAuthorAdmin(admin.ModelAdmin):
    list_display = ('content_submission','name')
    list_filter = ['content_submission']

admin.site.register(AbstractRequest)
admin.site.register(AbstractCategory)
admin.site.register(AbstractContentType)
admin.site.register(AbstractSubmission,AbstractSubmissionAdmin)
admin.site.register(AbstractSubmissionFile,AbstractSubmissionFileAdmin)
admin.site.register(AbstractSubmissionAuthor,AbstractSubmissionAuthorAdmin)
admin.site.register(AbstractSubmissionReview)