from django.conf.urls import *

urlpatterns = patterns('',

    url(r'^$', 'modules.abstracts.adminviews.abstract_requests', name='admin_abstracts'),

    url(r'^add/$','modules.abstracts.adminviews.add_abstract_request',name='admin_abstracts_add_abstract_request'),
    url(r'^(?P<abstract_id>[-\d]+)/edit/$','modules.abstracts.adminviews.edit_abstract_request',name='admin_abstracts_edit_abstract_request'),
    url(r'^(?P<abstract_id>[-\d]+)/delete/$','modules.abstracts.adminviews.delete_abstract_request',name='admin_abstracts_delete_abstract_request'),
    url(r'^(?P<abstract_id>[-\d]+)/enable/$','modules.abstracts.adminviews.enable_abstract_request',name='admin_abstracts_enable_abstract_request'),
    url(r'^(?P<abstract_id>[-\d]+)/disable/$','modules.abstracts.adminviews.disable_abstract_request',name='admin_abstracts_disable_abstract_request'),

    url(r'^(?P<abstract_id>[-\d]+)/submissions/$','modules.abstracts.adminviews.submissions',name='admin_abstracts_submissions'),
    url(r'^(?P<abstract_id>[-\d]+)/submissions/load-submission/$','modules.abstracts.adminviews.load_submission',name='admin_abstracts_load_submission'),
    url(r'^(?P<abstract_id>[-\d]+)/submissions/export/$','modules.abstracts.adminviews.export_submissions',name='admin_abstracts_submissions_export'),
    url(r'^(?P<abstract_id>[-\d]+)/submissions/export-general/$','modules.abstracts.adminviews.export_submissions_general',name='admin_abstracts_submissions_export_general'),
    url(r'^(?P<abstract_id>[-\d]+)/submissions/export-docx/$','modules.abstracts.adminviews.export_docx',name='admin_abstracts_submissions_export_docx'),
    url(r'^(?P<abstract_id>[-\d]+)/submissions/add-review-group/$','modules.abstracts.adminviews.add_all_submissions_review_group',name='admin_abstracts_add_all_submissions_review_group'),
    url(r'^(?P<abstract_id>[-\d]+)/submissions/delete-review-group/$','modules.abstracts.adminviews.delete_all_submissions_review_group',name='admin_abstracts_delete_all_submissions_review_group'),
    url(r'^(?P<abstract_id>[-\d]+)/submissions/send-review-requests/$','modules.abstracts.adminviews.send_all_review_requests',name='admin_abstracts_send_all_review_requests'),

    url(r'^(?P<abstract_id>[-\d]+)/submissions/approved/$','modules.abstracts.adminviews.approved_submissions',name='admin_abstracts_approved_submissions'),

    #url(r'^(?P<abstract_id>[-\d]+)/submissions/export-reviews/$','modules.abstracts.adminviews.export_submissions_reviews',name='admin_abstracts_submissions_export_reviews'),
    url(r'^(?P<abstract_id>[-\d]+)/submissions/(?P<submission_id>[-\d]+)/view/$','modules.abstracts.adminviews.view_submission',name='admin_abstracts_view_submission'),
    #url(r'^(?P<abstract_id>[-\d]+)/submissions/(?P<submission_id>[-\d]+)/edit/$','modules.abstracts.adminviews.edit_submission',name='admin_abstracts_edit_submission'),
    url(r'^(?P<abstract_id>[-\d]+)/submissions/(?P<submission_id>[-\d]+)/delete/$','modules.abstracts.adminviews.delete_submission',name='admin_abstracts_delete_submission'),
    url(r'^(?P<abstract_id>[-\d]+)/submissions/(?P<submission_id>[-\d]+)/approve/$','modules.abstracts.adminviews.approve_submission',name='admin_abstracts_approve_submission'),
    url(r'^(?P<abstract_id>[-\d]+)/submissions/(?P<submission_id>[-\d]+)/reject/$','modules.abstracts.adminviews.reject_submission',name='admin_abstracts_reject_submissions'),

    url(r'^(?P<abstract_id>[-\d]+)/submissions/(?P<submission_id>[-\d]+)/reviews/$','modules.abstracts.adminviews.submission_reviews',name='admin_abstracts_submission_reviews'),
    url(r'^(?P<abstract_id>[-\d]+)/submissions/(?P<submission_id>[-\d]+)/reviews/add-review/$','modules.abstracts.adminviews.add_submission_review',name='admin_abstracts_add_submission_review'),
    url(r'^(?P<abstract_id>[-\d]+)/submissions/(?P<submission_id>[-\d]+)/reviews/add-review-group/$','modules.abstracts.adminviews.add_submission_review_group',name='admin_abstracts_add_submission_review_group'),
    url(r'^(?P<abstract_id>[-\d]+)/submissions/(?P<submission_id>[-\d]+)/reviews/(?P<review_id>[-\d]+)/view/$','modules.abstracts.adminviews.view_submission_review',name='admin_abstracts_view_submission_review'),
    url(r'^(?P<abstract_id>[-\d]+)/submissions/(?P<submission_id>[-\d]+)/reviews/(?P<review_id>[-\d]+)/delete/$','modules.abstracts.adminviews.delete_submission_review',name='admin_abstracts_delete_submission_review'),
    url(r'^(?P<abstract_id>[-\d]+)/submissions/(?P<submission_id>[-\d]+)/reviews/send-requests/$','modules.abstracts.adminviews.send_review_requests',name='admin_abstracts_send_review_requests'),
    url(r'^(?P<abstract_id>[-\d]+)/submissions/(?P<submission_id>[-\d]+)/reviews/download/$','modules.abstracts.adminviews.download_reviews',name='admin_abstracts_download_submission_reviews'),
    url(r'^(?P<abstract_id>[-\d]+)/approve/$','modules.abstracts.adminviews.submissions_approve',name='admin_abstracts_approve'),

    url(r'^content-types/$','modules.abstracts.adminviews.content_types',name='admin_abstracts_content_types'),
    url(r'^content-types/add/$','modules.abstracts.adminviews.add_content_type',name='admin_abstracts_add_content_type'),
    url(r'^content-types/(?P<type_id>[-\d]+)/edit/$','modules.abstracts.adminviews.edit_content_type',name='admin_abstracts_edit_content_type'),
    url(r'^content-types/(?P<type_id>[-\d]+)/delete/$','modules.abstracts.adminviews.delete_content_type',name='admin_abstracts_delete_content_type'),

    url(r'^categories/$','modules.abstracts.adminviews.categories',name='admin_abstracts_categories'),
    url(r'^categories/add/$','modules.abstracts.adminviews.add_category',name='admin_abstracts_add_category'),
    url(r'^categories/(?P<category_id>[-\d]+)/edit/$','modules.abstracts.adminviews.edit_category',name='admin_abstracts_edit_category'),
    url(r'^categories/(?P<category_id>[-\d]+)/delete/$','modules.abstracts.adminviews.delete_category',name='admin_abstracts_delete_category'),

)
