from django.forms import ModelForm
from django import forms

from models import *
from modules.members.models import *

#admin forms

class AbstractRequestForm(ModelForm):

    class Meta:
        model = AbstractRequest
        exclude = ('slug',)
        
class AbstractContentTypeForm(ModelForm):
    
    class Meta:
        model = AbstractContentType
        exclude = ('slug',)
        
        
class AbstractCategoryForm(ModelForm):
    
    class Meta:
        model = AbstractCategory
        exclude = ('slug',)

class EditAbstractSubmissionForm(ModelForm):

    class Meta:
        model = AbstractSubmission
        exclude = ('type','abstract_request','status')

class AddSubmissionReviewForm(ModelForm):

    def __init__(self, *args, **kwargs):
        super(AddSubmissionReviewForm, self).__init__(*args, **kwargs)
        self.fields['reviewer'].queryset = Member.objects.filter(user_type='member',member_status='current',approved=True) 

    class Meta:
        model = AbstractSubmissionReview
        fields = ('reviewer',)
        
        
class DeleteSubmissionReviewForm(ModelForm):

    def __init__(self,*args,**kwargs):
        super(DeleteSubmissionReviewForm,self).__init__(*args,**kwargs)
        self.fields['reviewer'].label = 'Select Group to Remove'

    class Meta:
        model = AbstractSubmissionReview
        fields = ('reviewer',)

class AddSubmissionReviewGroupForm(forms.Form):

    group = forms.ModelChoiceField(label='Select Group to send to',queryset=MemberGroup.objects.all().order_by('name'))
    type = forms.ModelMultipleChoiceField(label='Select Type of submission to send',queryset=AbstractContentType.objects.all())
    category = forms.ModelMultipleChoiceField(label='Select Categories to send',queryset=AbstractCategory.objects.all())
    
class DeleteSubmissionReviewGroupForm(forms.Form):

    group = forms.ModelChoiceField(label='Select Group to Remove',queryset=MemberGroup.objects.all().order_by('name'))


#submission forms

class ConfirmationForm(ModelForm):

    def clean_all_authors_notified(self):
        data = self.cleaned_data['all_authors_notified']
        authors = self.cleaned_data['num_authors']
        if not data and authors >= 2:
            raise forms.ValidationError('Please confirm all authors have been notified')
        return data
        
    def __init__(self, *args, **kwargs):
        super(ConfirmationForm, self).__init__(*args, **kwargs)
        self.fields['num_authors'].widget = forms.HiddenInput()
        self.fields['all_authors_notified'].label = 'Please tick to indicate all authors have been contacted and agree to your submission'

    class Meta:
        model = AbstractSubmission
        fields = ('num_authors','all_authors_notified')

class AbstractSubmissionFormDetails(ModelForm):

    class Meta:
        model = AbstractSubmission

        fields = ('title','given_name','surname','email','telephone','date_of_birth','content_type')


class AbstractSubmissionTitleForm(ModelForm):

    def __init__(self, *args, **kwargs):
        fields_required = kwargs.pop('fields_required')
        super(AbstractSubmissionTitleForm, self).__init__(*args, **kwargs)
        if fields_required:
            self.fields['abstract_title'].required = True
            self.fields['abstract_category'].required = True

    class Meta:
        model = AbstractSubmission
        fields = ('abstract_title','abstract_category')

class AbstractSubmissionDataForm(ModelForm):
    
    def __init__(self, *args, **kwargs):
        fields_required = kwargs.pop('fields_required')
        super(AbstractSubmissionDataForm, self).__init__(*args, **kwargs)
        if fields_required:
            self.fields['abstract_content'].required = True
            self.fields['abstract_content'].widget.attrs['cols'] = 50
            self.fields['abstract_content'].widget.attrs['rows'] = 16
            self.fields['presenter'].required = True

    class Meta:
        model = AbstractSubmission
        fields = ('presenter','abstract_content',)
        widgets = {
            'presenter': forms.Select(),
        }

class AbstractSubmissionAuthorForm(ModelForm):

    class Meta:
        model = AbstractSubmissionAuthor
        fields = ('name','status','institution', 'department','email','telephone')


class AbstractSubmissionFileForm(ModelForm):

    class Meta:
        model = AbstractSubmissionFile
        fields = ('file',)


#review forms

class AbstractSubmissionReviewForm(ModelForm):

    def __init__(self, *args, **kwargs):
        super(AbstractSubmissionReviewForm, self).__init__(*args, **kwargs)
        self.fields['scorer_name'].required = True

    class Meta:
        model = AbstractSubmissionReview
        fields = ('scorer_name',)


class AbstractSubmissionReviewEvaluationForm(ModelForm):

    def __init__(self, *args, **kwargs):
        super(AbstractSubmissionReviewEvaluationForm, self).__init__(*args, **kwargs)
        self.fields['comment'].required = True

    class Meta:
        model = AbstractSubmissionReview
        fields = ('comment',)

class ApproveForm(ModelForm):
    class Meta:
        model = AbstractSubmission
        fields = ('status',)
        
class AbstractAddressForm(ModelForm):
    
    class Meta:
        model = AbstractSubmission
        fields = ('address_1','address_2','town','county','country','postcode',)
        
        
class AbstractInvoiceForm(ModelForm):
    

    
    class Meta:
        model = AbstractSubmission
        fields = ('invoice_company_name','invoice_email',)

    #def __init__(self, *args, **kwargs):
    #    super(ApproveForm, self).__init__(*args, **kwargs)
    #    if self.instance.id:
    #        self.fields['unique_code'].widget.attrs['readonly'] = True
