# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import models, migrations


class Migration(migrations.Migration):

    dependencies = [
        ('members', '0003_auto_20150904_1057'),
    ]

    operations = [
        migrations.CreateModel(
            name='AbstractCategory',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('name', models.CharField(max_length=200)),
                ('slug', models.SlugField(max_length=200)),
                ('order', models.IntegerField()),
            ],
            options={
                'ordering': ['order'],
            },
        ),
        migrations.CreateModel(
            name='AbstractContentType',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('name', models.CharField(max_length=200)),
                ('slug', models.SlugField(max_length=200)),
                ('code', models.CharField(max_length=10)),
                ('order', models.IntegerField()),
            ],
            options={
                'ordering': ['order'],
            },
        ),
        migrations.CreateModel(
            name='AbstractRequest',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('name', models.CharField(max_length=200)),
                ('slug', models.SlugField(max_length=200)),
                ('description', models.TextField()),
                ('enabled', models.BooleanField(default=True)),
                ('start_date', models.DateField()),
                ('end_date', models.DateField()),
                ('categories', models.ManyToManyField(to='abstracts.AbstractCategory')),
                ('content_types', models.ManyToManyField(to='abstracts.AbstractContentType')),
                ('member_groups_allowed', models.ManyToManyField(related_name='member_groups_allowed_abstract_request', verbose_name=b'Member Groups Allowed to View (Leave Blank for Public access)', to='members.MemberGroup', blank=True)),
                ('member_types_allowed', models.ManyToManyField(related_name='member_types_allowed_abstract_request', verbose_name=b'Member Types Allowed to View (Leave Blank for Public access)', to='members.MemberType', blank=True)),
            ],
        ),
        migrations.CreateModel(
            name='AbstractSubmission',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('title', models.CharField(max_length=20, choices=[('Mr', 'Mr'), ('Mrs', 'Mrs'), ('Miss', 'Miss'), ('Ms', 'Ms'), ('Doctor', 'Doctor'), ('Professor', 'Professor')])),
                ('given_name', models.CharField(max_length=200)),
                ('surname', models.CharField(max_length=200)),
                ('email', models.EmailField(max_length=254)),
                ('telephone', models.CharField(max_length=20)),
                ('date_of_birth', models.DateField()),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('updated', models.DateTimeField(auto_now=True)),
                ('first_save', models.BooleanField(default=True)),
                ('complete', models.BooleanField(default=False)),
                ('paid', models.BooleanField(default=False)),
                ('member_registered', models.BooleanField(default=False)),
                ('status', models.CharField(default=b'pending', max_length=200, choices=[('pending', 'Pending'), ('approved', 'Approved'), ('rejected', 'Rejected')])),
                ('unique_key', models.CharField(max_length=50, null=True, blank=True)),
                ('unique_code', models.CharField(max_length=10, null=True, blank=True)),
                ('num_authors', models.IntegerField(default=1)),
                ('all_authors_notified', models.BooleanField(default=False)),
                ('abstract_title', models.CharField(max_length=200, null=True, blank=True)),
                ('presenter', models.CharField(max_length=200, null=True, verbose_name=b'Who will be presenting', blank=True)),
                ('abstract_content', models.TextField(null=True, blank=True)),
                ('address_1', models.CharField(max_length=200, null=True, blank=True)),
                ('address_2', models.CharField(max_length=200, null=True, blank=True)),
                ('town', models.CharField(max_length=200, null=True, blank=True)),
                ('county', models.CharField(max_length=200, null=True, blank=True)),
                ('postcode', models.CharField(max_length=20, null=True, blank=True)),
                ('invoice_company_name', models.CharField(max_length=200, null=True, verbose_name=b'Company Name', blank=True)),
                ('invoice_email', models.EmailField(max_length=200, null=True, verbose_name=b'Email Address', blank=True)),
                ('abstract_category', models.ForeignKey(blank=True, to='abstracts.AbstractCategory', null=True)),
                ('abstract_request', models.ForeignKey(to='abstracts.AbstractRequest')),
                ('content_type', models.ForeignKey(verbose_name=b'submission type', to='abstracts.AbstractContentType')),
                ('country', models.ForeignKey(related_name='abstract_country', blank=True, to='members.Country', null=True)),
                ('member', models.ForeignKey(related_name='Member', blank=True, to='members.Member', null=True)),
            ],
            options={
                'ordering': ('content_type__order', 'abstract_category__order'),
            },
        ),
        migrations.CreateModel(
            name='AbstractSubmissionAuthor',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('name', models.CharField(max_length=200)),
                ('status', models.CharField(default=b'', max_length=200, verbose_name=b'grade', choices=[('', 'Please Select'), ('con', 'Consultant'), ('gp', 'GP'), ('vet', 'Veterinarian'), ('reg', 'Registrar'), ('doc', 'Doctor in training'), ('con-son', 'Consultant Sonographer'), ('son', 'Sonographer'), ('rad', 'Radiographer'), ('stu-son-rad', 'Student Sonographer / Radiographer'), ('edu', 'Educationalist'), ('ccs', 'Consultant Clinical Scientist'), ('cli-sci', 'Clinical Scientist'), ('phy', 'Physicist'), ('aaa-tech', 'AAA Technician'), ('vas-sci', 'Vascular Scientist')])),
                ('institution', models.CharField(max_length=200)),
                ('department', models.CharField(max_length=200)),
                ('email', models.EmailField(max_length=254)),
                ('telephone', models.CharField(max_length=20, verbose_name=b'contact number')),
                ('order', models.IntegerField()),
                ('content_submission', models.ForeignKey(to='abstracts.AbstractSubmission')),
            ],
        ),
        migrations.CreateModel(
            name='AbstractSubmissionFile',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('file', models.FileField(upload_to=b'abstracts/submission')),
                ('order', models.IntegerField()),
                ('content_submission', models.ForeignKey(to='abstracts.AbstractSubmission')),
            ],
        ),
        migrations.CreateModel(
            name='AbstractSubmissionReview',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('sent', models.BooleanField(default=False)),
                ('reviewed', models.BooleanField(default=False)),
                ('review_created', models.DateTimeField(null=True, blank=True)),
                ('scorer_name', models.CharField(max_length=200, null=True, blank=True)),
                ('comment', models.TextField(null=True, verbose_name=b'additional_comments', blank=True)),
                ('title_score', models.IntegerField(default=0, verbose_name=b'Title')),
                ('abstract_construction', models.IntegerField(default=0, verbose_name=b'construction')),
                ('content_score', models.IntegerField(default=0, verbose_name=b'Content')),
                ('relevance_score', models.IntegerField(default=0, verbose_name=b'Relevance')),
                ('priority_score', models.IntegerField(default=0)),
                ('content_submission', models.ForeignKey(to='abstracts.AbstractSubmission')),
                ('reviewer', models.ForeignKey(related_name='submission_reviewer', to='members.Member')),
            ],
            options={
                'ordering': ['content_submission', 'reviewer'],
            },
        ),
    ]
