#Django core bits
from django.shortcuts import render_to_response, get_object_or_404
from django.template import RequestContext, loader, Context
from django.contrib.auth.decorators import login_required, permission_required
from django.db.models import Q
from django.contrib.sites.models import Site
from django.conf import settings
from django.http import HttpResponseRedirect, Http404, HttpResponse
from django.core.urlresolvers import reverse
from django.contrib.auth.models import User, Group
from django.contrib import messages

from django.contrib.auth.models import *
from forms import *

from modules.core.decorators import *

@superuser_only
def users(request):

    users = User.objects.filter(is_staff=True)

    return render_to_response('admin/admin_users/admin-users.html',{'users':users},context_instance=RequestContext(request))

@superuser_only
def add_user(request):

    user_form = UserForm()
    password_form = UserPasswordForm()

    if request.POST:
        user_form = UserForm(request.POST)
        password_form = UserPasswordForm(request.POST)

        if user_form.is_valid() and password_form.is_valid():

            try:
                user = user_form.save(commit=False)
                user.is_staff = True
                user.set_password(request.POST['password1'])
                user.username = random_string_unique(20,User,'username')
                user.save()

                user_form.save_m2m()

                messages.success(request,'User has been created')
                return HttpResponseRedirect(reverse('admin_users'))

            except:
                messages.error(request,'Could not create User')

    return render_to_response('admin/admin_users/add-user.html',{'user_form':user_form,'password_form':password_form},context_instance=RequestContext(request))

@superuser_only
def edit_user(request,id):

    user = get_object_or_404(User,id=id)
    user_form = UserForm(instance=user)

    if request.POST:
        user_form = UserForm(request.POST,instance=user)

        if user_form.is_valid():
            #try:
            user_form.save()
            messages.success(request,'User Updated')

            return HttpResponseRedirect(reverse('admin_users'))

            #except:
            #    messages.error(request,'Could not update User')

    return render_to_response('admin/admin_users/edit-user.html',{'user':user,'user_form':user_form},context_instance=RequestContext(request))

@superuser_only
def change_password(request,id):

    user = get_object_or_404(User,id=id)
    password_form = UserPasswordForm()

    if request.POST:
        password_form = UserPasswordForm(request.POST)

        if password_form.is_valid():

            try:
                user.set_password(request.POST['password1'])
                user.save()

                messages.success(request,'Users password has been changed')
                return HttpResponseRedirect(reverse('admin_users'))

            except:
                messages.error(request,'Could not change users password')

    return render_to_response('admin/admin_users/change-password.html',{'user':user,'password_form':password_form},context_instance=RequestContext(request))

@superuser_only
def delete_user(request,id):

    user = get_object_or_404(User,id=id)

    try:
        member = Member.objects.get(user=user)
        messages.error(request,'Sorry, there is a member associated with this user.')
        return HttpResponseRedirect(reverse('admin_users'))

    except:
        pass

    try:
        user.delete()
        messages.success(request,'User has been deleted')

    except:
        messages.error(request,'Could not delete user')

    return HttpResponseRedirect(reverse('admin_users'))

@superuser_only
def groups(request):

    groups = Group.objects.all()

    return render_to_response('admin/admin_groups/groups.html',{'groups':groups},context_instance=RequestContext(request))

@superuser_only
def add_group(request):

    group_form = GroupForm()

    if request.POST:

        group_form = GroupForm(request.POST)

        if group_form.is_valid():
            try:
                group_form.save()

                messages.success(request,'Group has been created')
                return HttpResponseRedirect(reverse('admin_groups'))

            except:
                messages.error(request,'Could not create group')

    return render_to_response('admin/admin_groups/add-group.html',{'group_form':group_form},context_instance=RequestContext(request))


@superuser_only
def edit_group(request,id):

    group = get_object_or_404(Group,id=id)
    group_form = GroupForm(instance=group)

    if request.POST:
        group_form = GroupForm(request.POST,instance=group)

        if group_form.is_valid():
            try:
                group_form.save()

                messages.success(request,'Group has been updated')

                return HttpResponseRedirect(reverse('admin_groups'))

            except:
                messages.error(request,'Could not create group')

    return render_to_response('admin/admin_groups/edit-group.html',{'group':group,'group_form':group_form},context_instance=RequestContext(request))

@superuser_only
def delete_group(request,id):

    group = get_object_or_404(Group,id=id)

    try:
        group.delete()
        messages.success(request,'Group Deleted')

    except:
        messages.error(request,'Could not Delete Group')

    return HttpResponseRedirect(reverse('admin_groups'))
