from django.db import models
from django.utils import six
from django.contrib.auth.models import User


class AdminUser(models.Model):

    user = models.ForeignKey(User)

    class Meta:
        permissions = (
            ("can_access_abstracts", "Can Access Abstracts"),
            ("can_access_blocks", "Can Access Blocks"),
            ("can_access_contact", "Can Access Contact Submissions"),
            ("can_access_donations", "Can Access Donations"),
            ("can_access_elections", "Can Access Elections"),
            ("can_access_emails", "Can Access Emails"),
            ("can_access_mediacentre", "Can Access Mediacentre"),
            ("can_access_meeting_booking", "Can Access Meeting Booking"),
            ("can_access_members", "Can Access Members"),
            ("can_access_pages", "Can Access All Pages"),
            ("can_edit_certain_pages", "Can Edit Certain Pages"),
            ("can_access_resources", "Can Access Resources"),
            ("can_access_pump_priming", "Can Access Pump Priming"),
            ("can_access_travel_grants", "Can Access Travel Grants"),
        )


def permissions_new_unicode(self):

    item_class = six.text_type(self.content_type)
    item_permission = six.text_type(self.name)

    return '%s' % (item_permission)

from django.contrib.auth.models import Permission
Permission.__unicode__ = permissions_new_unicode
