from django.forms import ModelForm
from django import forms

from models import *

class HomepageContentForm(ModelForm):

    class Meta:
        model = HomepageSettings
        fields = ('banner_strapline','banner','main_title','main_subtitle','secondary_title','left_content','right_content')

class HomepageBlockEditForm(ModelForm):

    class Meta:
        model = HomepageBlock
        fields = ('name','image','content','link','block_type','sidebar')

class HomepageBlockAddForm(ModelForm):

    class Meta:
        model = HomepageBlock
        fields = ('name','image','content','link','block_type','sidebar')

class MenuItemForm(ModelForm):

    class Meta:
        model = MenuItem
        fields = ('name','url')


class ContentBlockForm(ModelForm):

    class Meta:
        model = ContentBlock
        fields = ('content',)


class HomepageSearchForm(ModelForm):

    class Meta:
        model = HomepageSearch
        fields = ('name','type','order')

class BannerForm(ModelForm):
    class Meta:
        model = BannerImage
        fields = ('title','sub_title','link','order','image')
