# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import models, migrations


class Migration(migrations.Migration):

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='BannerImage',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('order', models.IntegerField()),
                ('title', models.CharField(max_length=200)),
                ('link', models.CharField(max_length=100)),
                ('sub_title', models.CharField(max_length=200, null=True, blank=True)),
                ('image', models.ImageField(upload_to=b'widgets/banners')),
            ],
        ),
        migrations.CreateModel(
            name='BlockLayout',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('name', models.CharField(max_length=200)),
                ('slug', models.SlugField()),
            ],
        ),
        migrations.CreateModel(
            name='ContentBlock',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('name', models.CharField(max_length=200)),
                ('slug', models.SlugField(max_length=200)),
                ('description', models.TextField()),
                ('content', models.TextField()),
            ],
        ),
        migrations.CreateModel(
            name='HomepageBlock',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('name', models.CharField(max_length=150)),
                ('content', models.TextField(null=True, blank=True)),
                ('image', models.ImageField(null=True, upload_to=b'widgets', blank=True)),
                ('link', models.CharField(max_length=150, null=True, blank=True)),
                ('block_type', models.CharField(blank=True, max_length=20, null=True, choices=[('normal', 'Normal'), ('banner', 'Banner'), ('events-feed', b'Events Feed'), ('news-feed', b'News Feed')])),
                ('location', models.CharField(max_length=20, null=True, blank=True)),
                ('order', models.IntegerField(default=0)),
                ('active', models.BooleanField(default=False)),
                ('sidebar', models.BooleanField(default=False, verbose_name=b'Show Block in Sidebar')),
                ('block_layout', models.ForeignKey(blank=True, to='blocks.BlockLayout', null=True)),
            ],
        ),
        migrations.CreateModel(
            name='HomepageSearch',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('name', models.CharField(max_length=200)),
                ('slug', models.SlugField(max_length=200)),
                ('type', models.CharField(max_length=200, choices=[('content-type', 'Content Type'), ('audience', 'Audience')])),
                ('order', models.IntegerField()),
            ],
        ),
        migrations.CreateModel(
            name='HomepageSettings',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('banner_title', models.CharField(max_length=200, null=True, blank=True)),
                ('banner_subtitle', models.CharField(max_length=200, null=True, blank=True)),
                ('banner', models.ImageField(null=True, upload_to=b'homepage_banner', blank=True)),
                ('mobile_banner', models.ImageField(null=True, upload_to=b'homepage_banner', blank=True)),
                ('left_content', models.TextField(blank=True)),
                ('right_content', models.TextField(blank=True)),
                ('block_layout', models.ForeignKey(blank=True, to='blocks.BlockLayout', null=True)),
            ],
        ),
        migrations.CreateModel(
            name='Menu',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('name', models.CharField(max_length=200)),
                ('slug', models.SlugField(max_length=200)),
            ],
        ),
        migrations.CreateModel(
            name='MenuItem',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('name', models.CharField(max_length=200)),
                ('url', models.CharField(max_length=200)),
                ('order', models.IntegerField(default=0)),
                ('menu', models.ForeignKey(to='blocks.Menu')),
                ('parent', models.ForeignKey(blank=True, to='blocks.MenuItem', null=True)),
            ],
        ),
        migrations.AddField(
            model_name='bannerimage',
            name='block',
            field=models.ForeignKey(to='blocks.HomepageBlock'),
        ),
    ]
