from django.db import models

from django.conf import settings

from django.core.files.storage import FileSystemStorage

fs = FileSystemStorage(location=settings.PRIVATE_FILES)

class Certificate(models.Model):

    first_name = models.CharField(max_length=200, blank=True)
    last_name = models.CharField(max_length=200, blank=True)
    email = models.EmailField()
    member = models.ForeignKey('members.Member', blank=True, null=True,related_name='certificate_member')

    day_1 = models.BooleanField(default=False)
    day_2 = models.BooleanField(default=False)

    certificate = models.FileField(upload_to='certificates',storage=fs,blank=True)

    created = models.DateTimeField(auto_now_add=True)

    sent = models.BooleanField(default=False)

    def __unicode__(self):
        return self.email