from django.db import models
from django.core.urlresolvers import reverse

class Submission(models.Model):

    date_sent       = models.DateTimeField(auto_now_add=True)
    ip              = models.GenericIPAddressField()
    name            = models.CharField(max_length=60, verbose_name="Name")
    email           = models.EmailField(verbose_name="Email Address")
    telephone       = models.CharField(max_length=30, blank=True, verbose_name="Telephone Number")
    message         = models.TextField(verbose_name="Message")
    mailing_list    = models.BooleanField(default=False,verbose_name="Add yourself to the Non-Member Mailing List?")

    def __unicode__(self):
        return "%s" % self.date_sent
