#Django core bits
from django.shortcuts import render_to_response, get_object_or_404
from django.template import RequestContext, loader, Context
from django.contrib.auth.decorators import login_required, permission_required
from django.db.models import Q
from django.contrib.sites.models import Site
from django.conf import settings
from django.http import HttpResponseRedirect, Http404, HttpResponse
from django.core.urlresolvers import reverse
from django.contrib.auth.models import User, Group
from django.contrib import messages
from django.core.mail import EmailMessage

#Forms
from forms import *

import signals

#Models
from modules.pages.models import *
from models import *

import emails

def contact(request):
    
    try:
        page = Page.objects.get(url='contact-us')
    except:
        page = False

    form = ContactForm()
    recaptcha_form = ContactCaptchaForm()

    if request.POST:
        form = ContactForm(request.POST)
        recaptcha_form = ContactCaptchaForm(request.POST)
        if form.is_valid() and recaptcha_form.is_valid():
            submission = form.save(commit=False)
            submission.ip = request.META['REMOTE_ADDR']
            submission.save()

            emails.contact_submit(request=request, submission=submission)

            return render_to_response('public/contact/contact-submitted.html', {}, context_instance=RequestContext(request))

        else:
            messages.error(request,'Could not send your enquiry, please check the fields and resubmit.')

    return render_to_response('public/contact/contact.html', {'form': form,'recaptcha_form':recaptcha_form,'page':page}, context_instance=RequestContext(request))