from django import template
register = template.Library()
from datetime import datetime,date,time

@register.filter('field_type')
def field_type(ob):
    return ob.__class__.__name__

@register.filter('convert_date')
def convert_date(element):
    
    if type(element) is not date and type(element) is not datetime:
        date_element = datetime.strptime(element,'%d/%m/%Y')
        return date_element
    else:
        return element

@register.filter
def get_range( value ):
  return range( value )


from django.template.defaultfilters import linebreaksbr
from django.utils.html import escape
try:
    from django.utils.safestring import mark_safe
except ImportError: # v0.96 and 0.97-pre-autoescaping compat
    def mark_safe(x): return x
from pprint import pformat

def rawdump(x):
    if hasattr(x, '__dict__'):
        d = {
            '__str__':str(x),
            '__unicode__':unicode(x),
            '__repr__':repr(x),
        }
        d.update(x.__dict__)
        x = d
    output = pformat(x)+'\n'
    return output

def dump(x):
    return mark_safe(linebreaksbr(escape(rawdump(x))))

register.filter('rawdump', rawdump)
register.filter('dump', dump)


@register.filter
def url_target_blank(text):
    return text.replace('<a ', '<a target="_blank" ')
    
    
@register.filter('underscore_to_space')
def underscore_to_space(text):
    text = text.replace('_',' ')
    return text