from django.shortcuts import render_to_response
from django.template import RequestContext, Context
from functools import partial

def base_error(request, template_name=None):
    try:
        context = RequestContext(request)
    except:
        context = Context()
    return render_to_response(template_name, context_instance=context)

page_not_found = partial(base_error, template_name='404.html')
server_error = partial(base_error, template_name='500.html')