# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import models, migrations
import django.db.models.deletion
import modules.core.encryption


class Migration(migrations.Migration):

    dependencies = [
        ('members', '0003_auto_20150904_1057'),
    ]

    operations = [
        migrations.CreateModel(
            name='Donation',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('title', models.CharField(max_length=10, choices=[('Mr', 'Mr'), ('Mrs', 'Mrs'), ('Miss', 'Miss'), ('Ms', 'Ms'), ('Doctor', 'Doctor'), ('Professor', 'Professor')])),
                ('first_name', models.CharField(max_length=200)),
                ('surname', models.CharField(max_length=200)),
                ('email_address', models.EmailField(max_length=200)),
                ('address_1', modules.core.encryption.EncryptedCharField(max_length=869)),
                ('address_2', models.CharField(max_length=200, null=True, blank=True)),
                ('town', models.CharField(max_length=200)),
                ('county', models.CharField(max_length=200)),
                ('postcode', modules.core.encryption.EncryptedCharField(max_length=165)),
                ('telephone', models.CharField(max_length=40, verbose_name=b'Phone Number')),
                ('amount', models.FloatField(verbose_name=b'Amount you wish to donate (&pound;)')),
                ('gift_aid', models.BooleanField(default=False, verbose_name=b'<strong>Yes, I am a UK taxpayer and agree to the PSGBI claiming tax on all past, present and future donations I make</strong><br/><br/> By ticking this box I confirm that I am paying or will pay and amount of Income Tax and/or Capital Gains Tax to cover the amount the society will reclaim (6th April one year to 5th April the next year). Council Tax and VAT do not qualify towards Gift Aid. The society will reclaim 25p on every &pound;1 that has been given.')),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('unique_key', models.CharField(max_length=200)),
                ('complete', models.BooleanField(default=False)),
                ('country', models.ForeignKey(related_name='donation_countrt', to='members.Country')),
                ('member', models.ForeignKey(related_name='member_donation', on_delete=django.db.models.deletion.SET_NULL, blank=True, to='members.Member', null=True)),
            ],
        ),
    ]
