from django.db import models
from datetime import datetime, date, time
from modules.core.encryption import EncryptedCharField

from modules.notifications.models import *
from modules.payments.models import *

from signals import *

class Donation(models.Model):

    TITLE_CHOICES = (
        (u'Mr',u'Mr'),
        (u'Mrs',u'Mrs'),
        (u'Miss',u'Miss'),
        (u'Ms',u'Ms'),
        (u'Doctor',u'Doctor'),
        (u'Professor',u'Professor'),
    )

    member = models.ForeignKey('members.Member',blank=True,null=True,related_name='member_donation',on_delete=models.SET_NULL)

    title = models.CharField(max_length=10,choices=TITLE_CHOICES)
    first_name = models.CharField(max_length=200)
    surname = models.CharField(max_length=200)
    email_address = models.EmailField(max_length=200)
    address_1 = EncryptedCharField(max_length=200)
    address_2 = models.CharField(max_length=200,blank=True,null=True)
    town = models.CharField(max_length=200)
    county = models.CharField(max_length=200,blank=True,null=True)
    country = models.ForeignKey('members.Country',related_name='donation_country')
    postcode = EncryptedCharField(max_length=20)
    telephone = models.CharField(max_length=40,verbose_name='Phone Number')

    amount = models.FloatField(verbose_name='Amount you wish to donate (&pound;)')
    gift_aid = models.BooleanField(default=False,verbose_name='<strong>Yes, I am a UK taxpayer and agree to the %s claiming tax on all past, present and future donations I make</strong><br/><br/> By ticking this box I confirm that I am paying or will pay and amount of Income Tax and/or Capital Gains Tax to cover the amount the society will reclaim (6th April one year to 5th April the next year). Council Tax and VAT do not qualify towards Gift Aid. The society will reclaim 25p on every &pound;1 that has been given.' % (settings.WEBSITE_NAME))

    created = models.DateTimeField(auto_now_add=True)
    unique_key = models.CharField(max_length=200)
    complete = models.BooleanField(default=False)

    def __unicode__(self):
        return "%s %s %s" % (self.first_name,self.surname,self.created)

    def get_payment(self):
        payments = Payment.objects.filter(donation=self,status='complete')
        if payments:
            return payments[0]
        else:
            return False

def donation_confirmation_email_handler(sender,**kwargs):

    donation = kwargs['donation']

    try:
        template = EmailTemplate.objects.get(key='donation_confirmation_admin')

        if donation.gift_aid:
            gift_aid = 'Yes'
        else:
            gift_aid = 'No'

        content = template.content % (donation.first_name,donation.surname,donation.email_address,donation.amount,gift_aid,settings.URL,reverse('admin_donations_view_donation',args=[donation.id]),settings.URL,reverse('admin_donations_view_donation',args=[donation.id]))
        subject  = template.subject
        send_mail(template.key,subject, content, template.from_address.email_address, template.get_to_addresses())
    except Exception, e:
        raise e


donation_confirmation_email.connect(donation_confirmation_email_handler,dispatch_uid="donation_confirmation_email")
