#Django core bits
from django.shortcuts import render_to_response, get_object_or_404
from django.template import RequestContext, loader, Context
from django.contrib.sites.models import Site
from django.conf import settings
from django.http import HttpResponseRedirect, Http404, HttpResponse
from django.core.urlresolvers import reverse
from django.contrib.auth.models import User, Group
from django.contrib import messages
from django.template.defaultfilters import slugify
from datetime import datetime, date, time

from paypal.standard.forms import PayPalEncryptedPaymentsForm

from django.views.decorators.csrf import csrf_exempt

from modules.core.functions import *
from modules.members.functions import *
from modules.payments.functions import *

from signals import *

#Forms
from forms import *

#Models
from models import *
from modules.blocks.models import *
from modules.resources.models import *
from modules.members.models import *
from modules.payments.models import *

def donation(request):

    try:
        content_block = ContentBlock.objects.get(slug='donation-intro')
    except:
        content_block = False

    try:
        current_member = Member.objects.get(user=request.user)
    except:
        current_member = False

    if current_member:
        donation_form = DonationForm(initial={'title':current_member.title,'surname':current_member.surname,'first_name':current_member.given_name,'email_address':current_member.user.email,'address_1':current_member.address_1,'address_2':current_member.address_2,'town':current_member.town,'county':current_member.county,'country':current_member.country,'postcode':current_member.postcode,'telephone':current_member.telephone})
    else:
        donation_form = DonationForm()

    ga_form = GAForm()

    if request.POST:

        donation_form = DonationForm(request.POST)
        ga_form = GAForm(request.POST)

        if donation_form.is_valid() and ga_form.is_valid():

            try:
                donation = donation_form.save(commit=False)
                donation.unique_key = random_string_unique(100,Donation,'unique_key')
                donation.save()

                ga_form = GAForm(request.POST,instance=donation)
                ga_form.save()

                request.session['donation_key'] = donation.unique_key

                return HttpResponseRedirect(reverse('donation_payment'))

            except:

                messages.error(request,'Could Not save Donation')

    return render_to_response('public/donation/donation.html',{'content_block':content_block,'donation_form':donation_form,'ga_form':ga_form},context_instance=RequestContext(request))

def payment(request):

    if request.session.get('donation_key', False):
        donation = get_object_or_404(Donation,unique_key=request.session['donation_key'])
        if donation.complete:
            del request.session['donation_key']
            messages.error(request,'Sorry, you have already donated with these details.')
            return HttpResponseRedirect(reverse('donation'))
    else:
        messages.error(request,'You have not started your donation yet')
        return HttpResponseRedirect(reverse('donation'))

    payment = Payment(type='donation',donation=donation)
    payment.save()

    today = date.today()

    if settings.DEVELOPMENT:
        payment.invoice = "%s_Donation_%s_DEV" % (settings.WEBSITE_CODE,payment.id)
    else :
        payment.invoice = "%s_Donation_%s" % (settings.WEBSITE_CODE,payment.id)

    payment.save()

    paypal_dict = {
        "business": settings.PAYPAL_RECEIVER_EMAIL,
        "amount": donation.amount,
        "custom": "domnation",
        "item_name": '%s Donation' % (settings.WEBSITE_NAME),
        "currency_code": 'GBP',
        "invoice": payment.invoice,
        "notify_url": "%s%s" % (settings.URL, reverse('paypal-ipn')),
        "return_url": "%s%s" % (settings.URL, reverse('donation_payment_complete')),
        "cancel_return": "%s%s" % (settings.URL, reverse('donation_payment_failure')),
    }

    if settings.URL == 'http://127.0.0.1:8000':
        paypal_dict['notify_url'] = "%s%s" % (settings.NGROK_URL, reverse('paypal-ipn'))

    paypal_form = PayPalEncryptedPaymentsForm(initial=paypal_dict)

    return render_to_response('public/donation/payment.html',{'donation':donation,'paypal_form':paypal_form},context_instance=RequestContext(request))


def payment_complete(request):

    try:
        content_block = ContentBlock.objects.get(slug='donation-payment-complete')
    except:
        content_block = False

    return render_to_response('public/donation/payment-complete.html',{'content_block':content_block},context_instance=RequestContext(request))


def payment_failure(request):

    messages.error(request,'Sorry, your payment could not be taken at this time. If you wish to retry your payment, please click below.')
    return HttpResponseRedirect(reverse('donation_payment'))
