from django.forms import ModelForm
from django import forms

from models import *
from modules.members.models import *

class ElectionForm(ModelForm):

    def __init__(self,*args,**kwargs):
        super(ElectionForm,self).__init__(*args,**kwargs)
        self.fields['member_types_allowed_view'].help_text = 'Leave blank to allow All Members to View.'
        self.fields['member_groups_allowed_view'].help_text = ''
        self.fields['member_types_allowed_register'].help_text = 'Leave blank to allow All Members to register.'
        self.fields['member_groups_allowed_register'].help_text = ''
        self.fields['member_types_allowed_vote'].help_text = 'Leave blank to allow All Members to vote.'
        self.fields['member_groups_allowed_vote'].help_text = ''

    class Meta:
        model = Election
        exclude = ('slug',)
        
        
class ElectionPositionForm(ModelForm):
    
    def __init__(self,*args,**kwargs):
        super(ElectionPositionForm,self).__init__(*args,**kwargs)
        self.fields['member_types_allowed_register'].help_text = 'Leave blank to allow non-members to register.'
        self.fields['member_groups_allowed_register'].help_text = ''
        self.fields['member_types_allowed_vote'].help_text = 'Leave blank to allow non-members to vote.'
        self.fields['member_groups_allowed_vote'].help_text = ''
    
    class Meta:
        model = ElectionPosition
        exclude = ('election',)
        
class AddElectionCandidateForm(ModelForm):
    
    def __init__(self,*args,**kwargs):
        super(AddElectionCandidateForm,self).__init__(*args,**kwargs)
        self.fields['member'].queryset = Member.objects.filter(approved=True,member_status='current',user_type='member')
    
    class Meta:
        model = ElectionCandidate
        fields = ('member','position','manifesto')
        
class UpdateElectionCandidateForm(ModelForm):
    
    def __init__(self,*args,**kwargs):
        super(UpdateElectionCandidateForm,self).__init__(*args,**kwargs)
        self.fields['member'].queryset = Member.objects.filter(approved=True,member_status='current',user_type='member')
    
    class Meta:
        model = ElectionCandidate
        fields = ('member','title','given_name','surname','email','telephone','position','qualifications','current_post','hospital','manifesto','picture')

class ElectionRegistrationForm(ModelForm):
    
    def __init__(self, *args, **kwargs):
        position_choices = kwargs.pop('position_choices')
        super(ElectionRegistrationForm, self).__init__(*args, **kwargs)

        choices = []
        for position_choice in position_choices:
            choices.append([position_choice.id,position_choice.name])
        #raise Exception(choices)

        self.fields["telephone"].required = True
        self.fields["qualifications"].required = True
        self.fields["current_post"].required = True
        self.fields["hospital"].required = True

        self.fields["position"].choices = choices
        self.fields["position"].label = 'Position applying for'
        self.fields["manifesto"].label = 'R&eacute;sum&eacute;'
        self.fields["manifesto"].help_text  = 'Please enter a short manifesto (200 words) including your date of birth to acompany your application.'
        self.fields["sponsor_name_1"].label = 'Proposer Name'
        self.fields["sponsor_name_1"].required = True
        self.fields["sponsor_email_1"].label = 'Proposer Email'
        self.fields["sponsor_email_1"].help_text = 'Please enter the email address of a current Ordinary of Honorary member who will propose your candidacy'
        self.fields["sponsor_email_1"].required = True
        self.fields["sponsor_name_2"].label = 'Seconder Name'
        self.fields["sponsor_name_2"].required = True
        self.fields["sponsor_email_2"].label = 'Seconder Email'
        self.fields["sponsor_email_2"].help_text = 'Please enter the email address of a current Ordinary or Honorary member who will second your candidacy'
        self.fields["sponsor_email_2"].required = True
    
    class Meta:
        model = ElectionCandidate
        fields = ('title','given_name','surname','email','telephone','qualifications','current_post','hospital','picture','position','manifesto','sponsor_name_1','sponsor_email_1','sponsor_name_2','sponsor_email_2')

class ElectionRegistrationDOBForm(ModelForm):
    
    def __init__(self, *args, **kwargs):
        position_choices = kwargs.pop('position_choices')
        super(ElectionRegistrationDOBForm, self).__init__(*args, **kwargs)

        choices = []
        for position_choice in position_choices:
            choices.append([position_choice.id,position_choice.name])
        #raise Exception(choices)

        self.fields["telephone"].required = True
        self.fields["qualifications"].required = True
        self.fields["current_post"].required = True
        self.fields["hospital"].required = True

        self.fields["position"].choices = choices
        self.fields["position"].label = 'Position applying for'
        self.fields["manifesto"].label = 'R&eacute;sum&eacute;'
        self.fields["manifesto"].help_text  = 'Please enter a short manifesto (200 words) including your date of birth to acompany your application.'
        self.fields["sponsor_name_1"].label = 'Proposer Name'
        self.fields["sponsor_name_1"].required = True
        self.fields["sponsor_email_1"].label = 'Proposer Email'
        self.fields["sponsor_email_1"].help_text = 'Please enter the email address of a current Ordinary of Honorary member who will propose your candidacy'
        self.fields["sponsor_email_1"].required = True
        self.fields["sponsor_name_2"].label = 'Seconder Name'
        self.fields["sponsor_name_2"].required = True
        self.fields["sponsor_email_2"].label = 'Seconder Email'
        self.fields["sponsor_email_2"].help_text = 'Please enter the email address of a current Ordinary or Honorary member who will second your candidacy'
        self.fields["sponsor_email_2"].required = True
    
    class Meta:
        model = ElectionCandidate
        fields = ('title','given_name','surname','email','telephone','qualifications','current_post','hospital','picture','date_of_birth','position','manifesto','sponsor_name_1','sponsor_email_1','sponsor_name_2','sponsor_email_2')
