# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import models, migrations


class Migration(migrations.Migration):

    dependencies = [
        ('members', '0003_auto_20150904_1057'),
    ]

    operations = [
        migrations.CreateModel(
            name='Election',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('name', models.CharField(max_length=200)),
                ('slug', models.SlugField(max_length=200)),
                ('registration_introduction', models.TextField()),
                ('voting_introduction', models.TextField()),
                ('election_registration_starts', models.DateField(null=True, blank=True)),
                ('election_registration_ends', models.DateField(null=True, blank=True)),
                ('election_starts', models.DateField(null=True, verbose_name=b'Election Voting Starts', blank=True)),
                ('election_ends', models.DateField(null=True, verbose_name=b'Election Voting Ends', blank=True)),
                ('approval_deadline', models.DateField(null=True, blank=True)),
                ('confirmation_message', models.TextField(null=True, blank=True)),
                ('enabled', models.BooleanField(default=False)),
                ('show_dob', models.BooleanField(default=False, verbose_name=b'Show Date of Birth Field')),
                ('vote_for_self', models.BooleanField(default=False, verbose_name=b'Allow Members to Vote for themselves')),
                ('member_groups_allowed_register', models.ManyToManyField(related_name='member_groups_allowed_register', verbose_name=b'Member Groups Allowed to Register', to='members.MemberGroup', blank=True)),
                ('member_groups_allowed_view', models.ManyToManyField(related_name='member_groups_allowed_view', verbose_name=b'Member Groups Allowed to View', to='members.MemberGroup', blank=True)),
                ('member_groups_allowed_vote', models.ManyToManyField(related_name='member_groups_allowed_vote', verbose_name=b'Member Groups Allowed to Vote', to='members.MemberGroup', blank=True)),
                ('member_types_allowed_register', models.ManyToManyField(help_text=b'Leave blank to allow non-members to Register.', related_name='member_types_allowed_register', verbose_name=b'Member Types Allowed to Register', to='members.MemberType', blank=True)),
                ('member_types_allowed_view', models.ManyToManyField(help_text=b'Leave blank to allow non-members to View.', related_name='member_types_allowed_view', verbose_name=b'Member Types Allowed to View', to='members.MemberType', blank=True)),
                ('member_types_allowed_vote', models.ManyToManyField(help_text=b'Leave blank to allow non-members to Vote.', related_name='member_types_allowed_vote', verbose_name=b'Member Types Allowed to Vote', to='members.MemberType', blank=True)),
            ],
        ),
        migrations.CreateModel(
            name='ElectionCandidate',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('title', models.CharField(max_length=20)),
                ('given_name', models.CharField(max_length=200)),
                ('surname', models.CharField(max_length=200)),
                ('email', models.EmailField(max_length=254)),
                ('telephone', models.CharField(max_length=20, null=True, blank=True)),
                ('qualifications', models.TextField(null=True, blank=True)),
                ('current_post', models.CharField(max_length=200, null=True, blank=True)),
                ('hospital', models.CharField(max_length=200, null=True, verbose_name=b'Hospital or Clinic', blank=True)),
                ('date_of_birth', models.DateField(null=True, blank=True)),
                ('picture', models.ImageField(null=True, upload_to=b'elections/candidates', blank=True)),
                ('manifesto', models.TextField()),
                ('sponsor_name_1', models.CharField(max_length=200, null=True, blank=True)),
                ('sponsor_email_1', models.EmailField(max_length=200, null=True, blank=True)),
                ('sponsor_confirmed_1', models.BooleanField(default=False)),
                ('sponsor_key_1', models.CharField(max_length=200, null=True, blank=True)),
                ('sponsor_time_1', models.DateTimeField(null=True, blank=True)),
                ('sponsor_name_2', models.CharField(max_length=200, null=True, blank=True)),
                ('sponsor_email_2', models.EmailField(max_length=200, null=True, blank=True)),
                ('sponsor_confirmed_2', models.BooleanField(default=False)),
                ('sponsor_key_2', models.CharField(max_length=200, null=True, blank=True)),
                ('sponsor_time_2', models.DateTimeField(null=True, blank=True)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('status', models.CharField(default=b'pending', max_length=200, choices=[('pending', 'Pending'), ('approved', 'Approved'), ('rejected', 'Rejected')])),
                ('election', models.ForeignKey(to='elections.Election')),
                ('member', models.ForeignKey(to='members.Member')),
            ],
        ),
        migrations.CreateModel(
            name='ElectionPosition',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('name', models.CharField(max_length=200)),
                ('order', models.IntegerField()),
                ('num_votes', models.IntegerField(verbose_name=b'Number of votes allowed for each voter')),
                ('election', models.ForeignKey(to='elections.Election')),
                ('member_groups_allowed_register', models.ManyToManyField(related_name='position_member_groups_allowed_register', verbose_name=b'Member Groups Allowed to Register for this Position', to='members.MemberGroup', blank=True)),
                ('member_groups_allowed_vote', models.ManyToManyField(related_name='position_member_groups_allowed_vote', verbose_name=b'Member Groups Allowed to Vote for this Position', to='members.MemberGroup', blank=True)),
                ('member_types_allowed_register', models.ManyToManyField(related_name='position_member_types_allowed_register', verbose_name=b'Member Types Allowed to Register for this Position', to='members.MemberType', blank=True)),
                ('member_types_allowed_vote', models.ManyToManyField(related_name='position_member_types_allowed_vote', verbose_name=b'Member Types Allowed to Vote for this Position', to='members.MemberType', blank=True)),
            ],
            options={
                'ordering': ['order'],
            },
        ),
        migrations.CreateModel(
            name='ElectionVote',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('candidate', models.ForeignKey(to='elections.ElectionCandidate')),
                ('member', models.ForeignKey(to='members.Member')),
            ],
        ),
        migrations.AddField(
            model_name='electioncandidate',
            name='position',
            field=models.ForeignKey(to='elections.ElectionPosition'),
        ),
    ]
