#Django core bits
from django.shortcuts import render_to_response, get_object_or_404
from django.template import RequestContext, loader, Context
from django.contrib.auth.decorators import login_required, permission_required
from django.db.models import Q
from django.contrib.sites.models import Site
from django.conf import settings
from django.http import HttpResponseRedirect, Http404, HttpResponse
from django.core.urlresolvers import reverse
from django.contrib.auth.models import User, Group
from django.contrib import messages
from django.template.defaultfilters import slugify
from datetime import datetime, date, time

#Forms
from forms import *
from modules.core.forms import *

#Models
from models import *
from modules.members.models import *

def get_month_list(section):
	
    if section.type != 'news':
        return False

    articles = MediaArticle.objects.filter(section=section,published=True).order_by('-created')
	
    months = []
    for article in articles:
        art_month = article.created.month
        art_year = article.created.year

        monthtitle = datetime.strftime(article.created,"%B %Y")		
        #monthtitle = datetime.strptime("21/11/06 16:30", "%d/%m/%y %H:%M")

        add_to_array = True
        for month in months:
            if month['monthtitle'] == monthtitle:
                add_to_array = False

        if add_to_array:
            montharray = {}
            montharray['month'] = art_month
            montharray['year'] = art_year
            montharray['monthtitle'] = monthtitle 
            months.append(montharray)

    return months

#Public Views
def media_centre(request):

    sections = MediaSection.objects.all()

    return render_to_response('public/mediacentre/media_centre.html', {'sections': sections}, context_instance=RequestContext(request))


def media_section(request, section_slug):
    
    sections = MediaSection.objects.all()

    section  = get_object_or_404(MediaSection, slug=section_slug)
    months = get_month_list(section)

    today = datetime.now()

    if section.type == 'events':
        articles = MediaArticle.objects.filter(section=section, published=True,event_date_end__gt=today).order_by(section.order)
        archived_articles = MediaArticle.objects.filter(section=section, published=True,event_date_end__gt=today).order_by(section.order)
    else:
        articles = MediaArticle.objects.filter(section=section, published=True).order_by(section.order)
        articles = articles.filter(Q(archive_date__gt=today) | Q(archive_date__isnull=True))
        archived_articles = MediaArticle.objects.filter(section=section, published=True,archive_date__lt=today).order_by(section.order)

    final_articles = []
    final_archived_articles = []
    
    for article in articles:
        if article.get_permission(request) == 'allowed':
            final_articles.append(article)
            
    for article in archived_articles:
        if article.get_permission(request) == 'allowed':
            final_archived_articles.append(article)
    
    return render_to_response('public/mediacentre/media_section.html', {'sections':sections,'section': section, 'months':months,'articles': final_articles,'archived_articles':final_archived_articles}, context_instance=RequestContext(request))


def media_section_month(request, section_slug, year, month):
	
    sections = MediaSection.objects.all()

    section  = get_object_or_404(MediaSection, slug=section_slug,type='news')
    months = get_month_list(section)

    today =  datetime.now()
    
    year = int(year)
    month = int(month)
    current_month = date(year,month,1)
    monthname = datetime.strftime(current_month,"%B %Y")

    articles = MediaArticle.objects.filter(section=section, published=True, created__year=year,created__month=month).order_by(section.order)

    final_articles = []
    
    for article in articles:
        if article.get_permission(request) == 'allowed':
            final_articles.append(article)

    return render_to_response('public/mediacentre/media_section_archive.html', {'sections':sections,'section': section, 'articles': final_articles, 'year':year,'month':month,'monthname':monthname,'months':months}, context_instance=RequestContext(request))


def media_article(request, section_slug, article_slug):

    section  = get_object_or_404(MediaSection, slug=section_slug)
    months = get_month_list(section)

    article = get_object_or_404(MediaArticle, slug=article_slug, section__slug=section_slug, published=True)
    
    denied = False
    permission_denied = False
    
    if article.get_permission(request) == 'denied':
        login_form = LoginForm()
        return render_to_response('public/login/access-denied.html',{'login_form':login_form},context_instance=RequestContext(request))
    elif article.get_permission(request) == 'permission-denied':
        return render_to_response('public/login/permission-denied.html',{},context_instance=RequestContext(request))
        
    if request.user.is_authenticated():
        try:
            member = Member.objects.get(user=request.user)
            if member.expiry_date:
                if today >= member.expiry_date:
                    article_resources = MediaArticleResource.objects.filter(article=article,resource__limit_to_member_types__isnull=True).order_by('order')
                else:
                    article_resources = MediaArticleResource.objects.filter(Q(resource__limit_to_member_types__isnull=True) | Q(resource__limit_to_member_types=member.member_type),article=article).order_by('order')
            else:
                article_resources = MediaArticleResource.objects.filter(Q(resource__limit_to_member_types__isnull=True) | Q(resource__limit_to_member_types=member.member_type),article=article).order_by('order')        
        except:
            if request.user.is_superuser:
                article_resources = MediaArticleResource.objects.filter(article=article).order_by('order')
            else:
                article_resources = MediaArticleResource.objects.filter(article=article,resource__limit_to_member_types__isnull=True).order_by('order')
    else:
        article_resources = MediaArticleResource.objects.filter(article=article,resource__limit_to_member_types__isnull=True).order_by('order')
    
    
    final_resources = []    
    
    for resource in article_resources:
        
        if resource.resource.limit_to_member_groups.all():
            if request.user.is_authenticated():
                try:
                    member = Member.objects.get(user=request.user)
                
                    in_groups = False
                    for group in resource.resource.limit_to_member_groups.all():
                        if member in group.members.all():
                            in_groups = True
                        
                    if in_groups:
                        final_resources.append(resource)
                
                except:
                    if request.user.is_superuser:
                        final_resources.append(resource)
        else:
            final_resources.append(resource)

    return render_to_response('public/mediacentre/media_article.html', {'section':section,'months':months,'article': article,'article_resources':final_resources}, context_instance=RequestContext(request))
