from django.conf.urls import *

urlpatterns = patterns('',

    url(r'^$', 'modules.meeting_booking.adminviews.meetings', name='admin_meeting_booking'),

    url(r'^add/$','modules.meeting_booking.adminviews.add_meeting',name='admin_meeting_booking_add_meeting'),
    url(r'^(?P<meeting_id>[-\d]+)/edit/$','modules.meeting_booking.adminviews.edit_meeting',name='admin_meeting_booking_edit_meeting'),
    url(r'^(?P<meeting_id>[-\d]+)/delete/$','modules.meeting_booking.adminviews.delete_meeting',name='admin_meeting_booking_delete_meeting'),
    url(r'^(?P<meeting_id>[-\d]+)/enable/$','modules.meeting_booking.adminviews.enable_meeting',name='admin_meeting_booking_enable_meeting'),
    url(r'^(?P<meeting_id>[-\d]+)/disable/$','modules.meeting_booking.adminviews.disable_meeting',name='admin_meeting_booking_disable_meeting'),

    url(r'^(?P<meeting_id>[-\d]+)/confirmation-message/$','modules.meeting_booking.adminviews.update_confirmation_message',name='admin_meeting_booking_update_confirmation_message'),
    url(r'^(?P<meeting_id>[-\d]+)/duplicate/$','modules.meeting_booking.adminviews.duplicate_meeting',name='admin_meeting_booking_duplicate_meeting'),

    url(r'^(?P<meeting_id>[-\d]+)/booking-types/$','modules.meeting_booking.adminviews.booking_types',name='admin_meeting_booking_types'),
    url(r'^(?P<meeting_id>[-\d]+)/booking-types/add/$','modules.meeting_booking.adminviews.add_booking_type',name='admin_meeting_booking_add_type'),
    url(r'^(?P<meeting_id>[-\d]+)/booking-types/(?P<type_id>[-\d]+)/edit/$','modules.meeting_booking.adminviews.edit_booking_type',name='admin_meeting_booking_edit_type'),
    url(r'^(?P<meeting_id>[-\d]+)/booking-types/(?P<type_id>[-\d]+)/delete/$','modules.meeting_booking.adminviews.delete_booking_type',name='admin_meeting_booking_delete_type'),
    url(r'^(?P<meeting_id>[-\d]+)/booking-types/(?P<type_id>[-\d]+)/enable/$','modules.meeting_booking.adminviews.enable_booking_type',name='admin_meeting_booking_enable_type'),
    url(r'^(?P<meeting_id>[-\d]+)/booking-types/(?P<type_id>[-\d]+)/disable/$','modules.meeting_booking.adminviews.disable_booking_type',name='admin_meeting_booking_disable_type'),

    url(r'^(?P<meeting_id>[-\d]+)/sessions/$','modules.meeting_booking.adminviews.sessions',name='admin_meeting_booking_sessions'),

    url(r'^(?P<meeting_id>[-\d]+)/sessions/categories/add/$','modules.meeting_booking.adminviews.add_session_category',name='admin_meeting_booking_add_session_category'),
    url(r'^(?P<meeting_id>[-\d]+)/sessions/categories/(?P<category_id>[-\d]+)/edit/$','modules.meeting_booking.adminviews.edit_session_category',name='admin_meeting_booking_edit_session_category'),
    url(r'^(?P<meeting_id>[-\d]+)/sessions/categories/(?P<category_id>[-\d]+)/delete/$','modules.meeting_booking.adminviews.delete_session_category',name='admin_meeting_booking_delete_session_category'),

    url(r'^(?P<meeting_id>[-\d]+)/sessions/add/$','modules.meeting_booking.adminviews.add_session',name='admin_meeting_booking_add_session'),
    url(r'^(?P<meeting_id>[-\d]+)/sessions/(?P<session_id>[-\d]+)/edit/$','modules.meeting_booking.adminviews.edit_session',name='admin_meeting_booking_edit_session'),
    url(r'^(?P<meeting_id>[-\d]+)/sessions/(?P<session_id>[-\d]+)/delete/$','modules.meeting_booking.adminviews.delete_session',name='admin_meeting_booking_delete_session'),
    url(r'^(?P<meeting_id>[-\d]+)/sessions/(?P<session_id>[-\d]+)/bookings/$','modules.meeting_booking.adminviews.session_bookings',name='admin_meeting_booking_session_bookings'),
    url(r'^(?P<meeting_id>[-\d]+)/sessions/(?P<session_id>[-\d]+)/bookings/download/$','modules.meeting_booking.adminviews.download_session_bookings',name='admin_meeting_booking_download_session_bookings'),

    url(r'^(?P<meeting_id>[-\d]+)/social-events/$','modules.meeting_booking.adminviews.social_events',name='admin_meeting_booking_social_events'),
    url(r'^(?P<meeting_id>[-\d]+)/social-events/add/$','modules.meeting_booking.adminviews.add_social_event',name='admin_meeting_booking_add_social_event'),
    url(r'^(?P<meeting_id>[-\d]+)/social-events/(?P<event_id>[-\d]+)/edit/$','modules.meeting_booking.adminviews.edit_social_event',name='admin_meeting_booking_edit_social_event'),
    url(r'^(?P<meeting_id>[-\d]+)/social-events/(?P<event_id>[-\d]+)/delete/$','modules.meeting_booking.adminviews.delete_social_event',name='admin_meeting_booking_delete_social_event'),

    url(r'^(?P<meeting_id>[-\d]+)/days/$','modules.meeting_booking.adminviews.days',name='admin_meeting_booking_days'),
    url(r'^(?P<meeting_id>[-\d]+)/days/add/$','modules.meeting_booking.adminviews.add_day',name='admin_meeting_booking_add_day'),
    url(r'^(?P<meeting_id>[-\d]+)/days/(?P<day_id>[-\d]+)/edit/$','modules.meeting_booking.adminviews.edit_day',name='admin_meeting_booking_edit_day'),
    url(r'^(?P<meeting_id>[-\d]+)/days/(?P<day_id>[-\d]+)/delete/$','modules.meeting_booking.adminviews.delete_day',name='admin_meeting_booking_delete_day'),

    url(r'^(?P<meeting_id>[-\d]+)/resources/$','modules.meeting_booking.adminviews.resources',name='admin_meeting_booking_resources'),
    url(r'^(?P<meeting_id>[-\d]+)/resources/add/$','modules.meeting_booking.adminviews.add_resource', name='admin_meeting_booking__addresource'),
    url(r'^(?P<meeting_id>[-\d]+)/resources/(?P<resource_id>[-\d]+)/edit/$','modules.meeting_booking.adminviews.edit_resource', name='admin_meeting_booking_edit_resource'),
    url(r'^(?P<meeting_id>[-\d]+)/resources/(?P<resource_id>[-\d]+)/delete/$','modules.meeting_booking.adminviews.delete_resource', name='admin_meeting_booking_delete_resource'),

    url(r'^(?P<meeting_id>[-\d]+)/bookings/$','modules.meeting_booking.adminviews.bookings',name='admin_meeting_booking_bookings'),
    url(r'^(?P<meeting_id>[-\d]+)/bookings/new/$','modules.meeting_booking.adminviews.new_booking',name='admin_meeting_booking_new_booking'),
    url(r'^(?P<meeting_id>[-\d]+)/bookings/(?P<booking_id>[-\d]+)/invoice/$','modules.meeting_booking.adminviews.invoice_booking',name='admin_meeting_booking_invoice'),
    url(r'^(?P<meeting_id>[-\d]+)/bookings/(?P<booking_id>[-\d]+)/approve/$','modules.meeting_booking.adminviews.approve_booking',name='admin_meeting_booking_approve_booking'),
    url(r'^(?P<meeting_id>[-\d]+)/bookings/(?P<booking_id>[-\d]+)/cancel/$','modules.meeting_booking.adminviews.cancel_booking',name='admin_meeting_booking_cancel_booking'),
    url(r'^(?P<meeting_id>[-\d]+)/bookings/(?P<booking_id>[-\d]+)/mark-paid/$','modules.meeting_booking.adminviews.mark_paid_booking',name='admin_meeting_booking_mark_paid'),
    url(r'^(?P<meeting_id>[-\d]+)/bookings/(?P<booking_id>[-\d]+)/edit/$','modules.meeting_booking.adminviews.edit_booking',name='admin_meeting_booking_edit_booking'),
    url(r'^(?P<meeting_id>[-\d]+)/bookings/(?P<booking_id>[-\d]+)/view/$','modules.meeting_booking.adminviews.view_booking',name='admin_meeting_booking_view_booking'),
    url(r'^(?P<meeting_id>[-\d]+)/bookings/(?P<booking_id>[-\d]+)/reject/$','modules.meeting_booking.adminviews.reject_booking',name='admin_meeting_booking_reject_booking'),
    url(r'^(?P<meeting_id>[-\d]+)/bookings/(?P<booking_id>[-\d]+)/delete/$','modules.meeting_booking.adminviews.delete_booking',name='admin_meeting_booking_delete_booking'),
    url(r'^(?P<meeting_id>[-\d]+)/bookings/(?P<booking_id>[-\d]+)/reminder/$','modules.meeting_booking.adminviews.incomplete_reminder',name='admin_meeting_booking_incomplete_reminder'),

    url(r'^(?P<meeting_id>[-\d]+)/bookings/(?P<booking_id>[-\d]+)/resend-email/$','modules.meeting_booking.adminviews.resend_booking',name='admin_meeting_booking_resend_booking'),

    url(r'^(?P<meeting_id>[-\d]+)/reports/', include('modules.meeting_booking.reports.adminurls')),

)
