# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models
import modules.core.encryption


class Migration(migrations.Migration):

    dependencies = [
        ('meeting_booking', '0009_auto_20190611_1726'),
    ]

    operations = [
        migrations.AddField(
            model_name='meetingbooking',
            name='sharing',
            field=models.BooleanField(default=False, verbose_name=b'Please indicate you are willing to have your name and organisation details shared with our sponsors. Agreeing to this helps us attract sponsors, by demonstrating the calibre and experience of our delegates'),
        ),
        migrations.AlterField(
            model_name='meetingbooking',
            name='address_1',
            field=modules.core.encryption.EncryptedCharField(max_length=1765, null=True, blank=True),
        ),
        migrations.AlterField(
            model_name='meetingbooking',
            name='postcode',
            field=modules.core.encryption.EncryptedCharField(max_length=357, null=True, blank=True),
        ),
        migrations.AlterField(
            model_name='meetingbooking',
            name='requirements',
            field=models.TextField(help_text=b'Please complete this box if you have any special requirements for your booking, for example health requirements.', null=True, blank=True),
        ),
    ]
