def payment(request,meeting_slug):

    meeting = get_object_or_404(Meeting,slug=meeting_slug)

    if not get_access(request,meeting):
        return HttpResponseRedirect(reverse('meetings_access_denied',args=[meeting.slug]))

    if request.session.get('meeting_booking_key', False):
        meeting_booking = get_object_or_404(MeetingBooking,unique_key=request.session['meeting_booking_key'])
        if not meeting_booking.type:
            return HttpResponseRedirect(reverse('meeting_booking_tickets',args=[meeting.slug]))

        if meeting_booking.complete:
            del request.session['meeting_booking_key']
            messages.error(request,'Sorry, you have already registered for this meeting')
            return HttpResponseRedirect(reverse('meeting_booking_meeting',args=[meeting.slug]))

    else:
        return HttpResponseRedirect(reverse('meeting_booking_meeting',args=[meeting.slug]))

    meeting_booking_days = MeetingDayBooking.objects.filter(meeting_booking=meeting_booking).order_by('meeting_day__order')
    sessions = MeetingSessionBooking.objects.filter(meeting_booking=meeting_booking,waiting_list=False)
    waiting_list_sessions = MeetingSessionBooking.objects.filter(meeting_booking=meeting_booking,waiting_list=True)
    social_events = MeetingSocialEventBooking.objects.filter(meeting_booking=meeting_booking)

    total_cost = meeting_booking.get_total()

    payment = Payment(member=meeting_booking.member,type='meeting-booking',meeting_booking=meeting_booking)
    payment.save()

    if settings.DEVELOPMENT:
        payment.vendortxcode = "Meeting_Payment_%sD" % (payment.id)
    else :
        payment.vendortxcode = "Meeting_Payment_%s" % (payment.id)

    payment.save()

    crypt_contents = {
        'VendorTxCode': payment.vendortxcode,
        'Amount': total_cost,
        'Currency': 'GBP',
        'Description': '%s Meeting Booking - %s' % (settings.WEBSITE_NAME,meeting.name),
        'SuccessURL' : "%s%s" % (settings.MEETING_URL, reverse('meeting_booking_payment_complete',args=[meeting.slug])),
        'FailureURL' : "%s%s" % (settings.MEETING_URL, reverse('meeting_booking_payment_failure',args=[meeting.slug])),
        'CustomerName': "%s %s" % (meeting_booking.given_name,meeting_booking.surname),
        'CustomerEmail': meeting_booking.email_address,
        'BillingSurname': meeting_booking.surname,
        'BillingFirstnames': meeting_booking.given_name,
        'DeliverySurname': meeting_booking.surname,
        'DeliveryFirstNames' :meeting_booking.given_name
    }


    crypt_contents['BillingAddress1'] = meeting_booking.address_1
    if meeting_booking.member.address_2:
        crypt_contents['BillingAddress2'] = meeting_booking.address_2
    crypt_contents['BillingCity'] = meeting_booking.town
    crypt_contents['BillingPostCode'] = meeting_booking.postcode
    crypt_contents['BillingCountry'] = meeting_booking.country.iso_code

    crypt_contents['DeliveryAddress1'] = meeting_booking.address_1
    if meeting_booking.address_2:
        crypt_contents['DeliveryAddress2'] = meeting_booking.address_2
    crypt_contents['DeliveryCity'] = meeting_booking.town
    crypt_contents['DeliveryPostCode'] = meeting_booking.postcode
    crypt_contents['DeliveryCountry'] = meeting_booking.country.iso_code


    encrypted_crypt_string = get_encrypted_crypt(crypt_contents)
    sage_pay_vendor = settings.SAGE_PAY_VENDOR
    sage_pay_url = settings.SAGE_PAY_URL

    return render_to_response('public/payment.html',{'meeting':meeting,'meeting_booking':meeting_booking,'meeting_booking_days':meeting_booking_days,'sessions':sessions,'waiting_list_sessions':waiting_list_sessions,'social_events':social_events,'total_cost':total_cost,'sage_pay_vendor':sage_pay_vendor,'sage_pay_url':sage_pay_url,'encrypted_crypt_string':encrypted_crypt_string},context_instance=RequestContext(request))

@csrf_exempt
def payment_complete(request,meeting_slug):

    meeting = get_object_or_404(Meeting,slug=meeting_slug)
    try:
        content_block = ContentBlock.objects.get(slug='meeting-payment-complete')
    except:
        content_block = False

    if request.GET.get('crypt'):
        crypt = request.GET.get('crypt')

        data = decode_response(crypt)

        #try:
        payment = Payment.objects.get(vendortxcode=data['VendorTxCode'])

        if payment.status != 'complete':

            #raise Exception(data)

            payment.status = 'complete'
            payment.amount = data['Amount']
            payment.save()

            meeting_booking = payment.meeting_booking

            meeting_booking.complete = True
            meeting_booking.paid = True
            meeting_booking.price_paid = payment.amount
            meeting_booking.save()

            receipt_name = '%s' % (meeting)
            receipt = Receipt(member=meeting_booking.member,meeting_booking=meeting_booking,type='meeting-booking',name=receipt_name,amount_paid=payment.amount,payment_type='Credit Card')
            receipt.unique_key = random_string_unique(20,Receipt,'unique_key')
            receipt.save()

            #try:
            # create an API client instance
            client = pdfcrowd.Client("calmdigital", "dc33e7c4525620565185d0a00d90b8f0")
            client.setPageMargins('50','50','0','50')

            # convert an HTML string and save the result to a file
            output_file = open(os.path.join(settings.MEDIA_ROOT, 'members/receipts/meeting_booking_%s.pdf' % (receipt.id)), 'wb')

            if settings.URL == 'http://127.0.0.1:8000':
                client.convertURI('%s%s' % (settings.NGROK_URL,reverse('my_receipts_view_pdf',args=[receipt.unique_key])),output_file)
            else:
                client.convertURI('%s%s' % (settings.URL,reverse('my_receipts_view_pdf',args=[receipt.unique_key])),output_file)

            output_file.close()
            #except:
            #    pass

            receipt.file = 'members/receipts/meeting_booking_%s.pdf' % (receipt.id)
            receipt.save()

            meeting_booking_confirmation_email.send(sender=None, meeting_booking=meeting_booking,receipt=receipt)

            try:
                payment.update_with_data(data)
            except:
                pass

        else:
            pass
            #is a refresh so do nothing

        #except:
        #    messages.error(request,'Sorry, could not find a transasction matching the result')
    elif request.session.get('meeting_booking_key', False):
        if request.session.get('meeting_booking_key', False):
            meeting_booking = get_object_or_404(MeetingBooking,unique_key=request.session['meeting_booking_key'])
            if meeting_booking.complete:
                del request.session['meeting_booking_key']
                messages.error(request,'Sorry, you have already registered for this meeting')
                return HttpResponseRedirect(reverse('meeting_booking_meeting',args=[meeting.slug]))
            elif not meeting_booking.type:
                return HttpResponseRedirect(reverse('meeting_booking_tickets',args=[meeting.slug]))
            else:
                if meeting_booking.get_total() == 0:

                    meeting_booking.complete = True
                    meeting_booking.paid = True
                    meeting_booking.price_paid = 0
                    meeting_booking.save()

                    #emails need to go here
                    meeting_booking_confirmation_email.send(sender=None, meeting_booking=meeting_booking,receipt=False)

                else:
                    return HttpResponseRedirect(reverse('meeting_booking_payment',args=[meeting.slug]))

        else:
            return HttpResponseRedirect(reverse('meeting_booking_meeting',args=[meeting.slug]))
    else:
        raise Http404

    if request.session.get('meeting_booking_key',False):
        del request.session['meeting_booking_key']

    return render_to_response('public/payment_complete.html',{'meeting':meeting,'content_block':content_block},context_instance=RequestContext(request))


def payment_failure(request,meeting_slug):

    meeting = get_object_or_404(Meeting,slug=meeting_slug)
    try:
        content_block = ContentBlock.objects.get(slug='meeting-payment-failure')
    except:
        content_block = False

    try:
        crypt = request.GET.get('crypt')

        data = decode_response(crypt)

        try:
            payment = Payment.objects.get(vendortxcode=data['VendorTxCode'])

            if payment.status != 'complete':

                payment.status = 'rejected'
                payment.save()

                payment.update_with_data(data)

        except:
            messages.error(request,'Sorry, could not find a transasction matching the result')
    except:
        messages.error(request,'Sorry, could not load the transaction data.')

    messages.error(request,'Sorry, your payment could not be taken at this time. If you wish to retry your payment, please click below.')
    return HttpResponseRedirect(reverse('meeting_booking_payment',args=[meeting.slug]))
