#Django core bits
from django.shortcuts import render_to_response, get_object_or_404
from django.template import RequestContext, loader, Context
from django.contrib.auth.decorators import login_required, permission_required
from django.db.models import Q
from django.conf import settings
from django.http import HttpResponseRedirect, Http404, HttpResponse
from django.core.urlresolvers import reverse
from django.contrib.auth.models import User, Group
from django.core.mail import EmailMessage
from django.contrib import messages
from datetime import datetime,date,time
from django.views.decorators.csrf import csrf_exempt
from django.contrib.auth import logout, views, update_session_auth_hash

from dateutil.relativedelta import relativedelta
from calendar import *
#Others
import random,csv,string

import pdfcrowd

#Forms
from forms import *

#Models
from models import *
from modules.blocks.models import *
from modules.meeting_booking.models import *
from modules.payments.models import *

from functions import *
from modules.payments.functions import *
from modules.core.functions import *
from modules.core.decorators import *

from signals import *

from paypal.standard.forms import PayPalEncryptedPaymentsForm

@members_only
def account_home(request):

    member = get_object_or_404(Member,user=request.user)
    user_activity = UserActivity.objects.filter(member=member).order_by('-created')[:20]

    unread_activity = UserActivity.objects.filter(member=member,read=False)
    unread_count  = unread_activity.count()

    if member.temp_password:
        messages.warning(request,'Please update your confirm your details before proceeding to your account.')
        return HttpResponseRedirect(reverse('update_details_member'))

    return render_to_response('members/home.html',{'user_activity':user_activity,'unread_activity':unread_activity}, context_instance=RequestContext(request))

@members_only
def dismiss_activity(request,id):

    member = get_object_or_404(Member,user=request.user)
    user_activity = get_object_or_404(UserActivity,id=id,member=member)

    user_activity.read = True
    user_activity.save()

    return HttpResponse('Ok')

@members_only
def remove_activity(request,id):

    member = get_object_or_404(Member,user=request.user)
    user_activity = get_object_or_404(UserActivity,id=id,member=member)

    try:
        user_activity.delete()
        return HttpResponse('Ok')
    except:
        raise Http404

@members_only
def activity_category(request):

    member = get_object_or_404(Member,user=request.user)

    if request.POST:

        if request.POST.get('category'):

            category = request.POST['category']

            if category == 'all':
                return HttpResponseRedirect(reverse('account_home'))

            if category == 'general':
                category_title = 'General Activity'
            elif category == 'meeting-notification':
                category_title = 'Meeting Notifications'
            elif category == 'voting-notification':
                category_title = 'Voting Notifications'
            elif category == 'member-notification':
                category_title = 'Member Notifications'
            elif category == 'account-notification':
                category_title = 'Account Notifications'
            elif category == 'certificate-notification':
                category_title = 'Certificate Notifications'
            else:
                category_title = ''

            activity = UserActivity.objects.filter(type=category,member=member).order_by('-created')

            return render_to_response('members/activity-category.html',{'category_activity':activity,'current_category':category,'category_title':category_title},context_instance=RequestContext(request))

    return HttpResponseRedirect(reverse('account_home'))

@members_only
def my_account(request):

    member = get_object_or_404(Member,user=request.user)

    form = MemberProfileImageForm()

    today = date.today()
    three_months = today+relativedelta(months=+3)

    member_expiring = False
    member_expired = False

    if member.expiry_date:
        if three_months >= member.expiry_date:
            member_expiring = True
            if today >= member.expiry_date:
                member_expired = True

    return render_to_response('members/account/my-account.html',{'member_expiring':member_expiring,'member_expired':member_expired,'form':form},context_instance=RequestContext(request))

@members_only
def update_details_member(request):

    member = get_object_or_404(Member,user=request.user,user_type='member')

    update_user_form = UpdateUserForm(instance=member.user)
    update_personal_form = RegistrationFormPersonal(instance=member)
    update_personal_address_form = RegistrationFormPersonalAddress(instance=member)
    update_hospital_form = RegistrationFormHospital(instance=member)
    update_work_skip_form = RegistrationFormWorkSkip(instance=member)
    # update_other_societies_form = RegistrationFormOtherSocieties(instance=member)
    # update_areas_form = RegistrationFormAreas(instance=member)
    update_terms_form = RegistrationFormTerms(instance=member)

    if request.POST:

        forms = [update_personal_form,update_personal_address_form,update_hospital_form]
        updated_fields = find_updated_fields(request,member,update_user_form,forms)

        update_user_form = UpdateUserForm(request.POST,instance=member.user)
        update_personal_form = RegistrationFormPersonal(request.POST,instance=member)
        update_personal_address_form = RegistrationFormPersonalAddress(request.POST,instance=member)
        update_hospital_form = RegistrationFormHospital(request.POST,instance=member)
        update_work_skip_form = RegistrationFormWorkSkip(request.POST,instance=member)
        # update_other_societies_form = RegistrationFormOtherSocieties(request.POST,instance=member)
        # update_areas_form = RegistrationFormAreas(request.POST,instance=member)
        update_terms_form = RegistrationFormTerms(request.POST, instance=member)

        if update_user_form.is_valid() and update_personal_form.is_valid() and update_personal_address_form.is_valid() and update_terms_form.is_valid():

            if update_hospital_form.is_valid() or update_work_skip_form.is_valid():

                #try:

                update_user_form.save()
                update_personal_form.save()
                update_personal_address_form.save()
                if update_hospital_form.is_valid():
                    update_hospital_form.save()
                if update_work_skip_form.is_valid():
                    update_work_skip_form.save()
                # update_other_societies_form.save()
                # update_areas_form.save()
                update_terms_form.save()

                if updated_fields:
                    details_updated.send(sender=None,request=request,member=member,updated_fields=updated_fields)

                messages.success(request,'Your details have been updated')

                if member.temp_password:
                    return HttpResponseRedirect(reverse('change_password'))
                else:
                    return HttpResponseRedirect(reverse('my_account'))

            #except:
            #    messages.error(request,'Sorry, could not update your profile')

    return render_to_response('members/account/update-details-member.html',{'member':member,'update_user_form':update_user_form,'update_personal_form':update_personal_form,'update_personal_address_form':update_personal_address_form,'update_hospital_form':update_hospital_form,'update_work_skip_form':update_work_skip_form, 'update_terms_form':update_terms_form}, context_instance=RequestContext(request))

@members_only
def update_details_delegate(request):

    member = get_object_or_404(Member,user=request.user,user_type='non-member')

    update_user_form = UpdateUserForm(instance=member.user)
    update_delegate_form = UpdateDelegateForm(instance=member)

    if request.POST:

        update_user_form = UpdateUserForm(request.POST,instance=member.user)
        update_delegate_form = UpdateDelegateForm(request.POST,instance=member)

        if update_user_form.is_valid() and update_delegate_form.is_valid():

            try:
                update_user_form.save()
                update_delegate_form.save()

                messages.success(request,'Your details have been saved')

                return HttpResponseRedirect(reverse('my_account'))

            except:
                messages.error(request,'Could not save your details')

    return render_to_response('members/account/update-details-delegate.html',{'member':member,'update_user_form':update_user_form,'update_delegate_form':update_delegate_form},context_instance=RequestContext(request))


@members_only
def change_password(request):

    member = get_object_or_404(Member,user=request.user)
    reset_required = member.temp_password

    error = ''
    form = MemberPasswordForm()
    if request.POST:

        form = MemberPasswordForm(request.POST)
        if form.is_valid():
            #check passwords match
            if form.cleaned_data['password'] == form.cleaned_data['password2']:
                #try:
                member.user.set_password(form.cleaned_data['password'])
                update_session_auth_hash(request, member.user)
                member.user.save()
                messages.success(request, 'Your Password has been changed')
                #except:
                #    messages.error(request, 'Could not change password')

                member.temp_password = False
                member.save()

                reset_password_notification = UserActivity(member=member,title='Your Password Has Been Changed',text='Please now login with your new password.',type='account-notification')
                reset_password_notification.save()

                return HttpResponseRedirect(reverse('my_account'))

            else:
                error = 'Passwords do not match'

    return render_to_response('members/account/change-password.html', {'form': form,'reset_required':reset_required,'error': error}, context_instance=RequestContext(request))

@members_only
def emails(request):

    member = get_object_or_404(Member,user=request.user)
    emails = member.get_emails()

    return render_to_response('members/emails/emails.html',{'member':member,'emails':emails},context_instance=RequestContext(request))

@members_only
def view_email(request,email_id):

    member = get_object_or_404(Member,user=request.user)
    email = get_object_or_404(AdminMessage,id=email_id)

    if not member.can_access_email(email):
        messages.error(request,'Sorry, you cannot access this email')
        return HttpResponseRedirect(reverse('account_emails'))

    return render_to_response('members/emails/view-email.html',{'member':member,'email':email},context_instance=RequestContext(request))


@members_only
def change_image(request):

    user = request.user
    member = get_object_or_404(Member,user=user)

    if request.POST:
        if request.FILES['image']:
            member.profile_picture = request.FILES['image']
            member.save()

            return HttpResponseRedirect(reverse('my_account'))

        else:
            return HttpResponseRedirect(reverse('my_account'))

    else:
        return HttpResponseRedirect(reverse('my_account'))


@members_only
def membership(request):

    member = get_object_or_404(Member,user=request.user)

    try:
        direct_debit = MemberDirectDebit.objects.get(status='current',member=member)
    except:
        direct_debit = False

    member_expiring = False
    member_expired = False

    today = date.today()
    three_months = today+relativedelta(months=+3)

    if member.expiry_date:
        if three_months >= member.expiry_date:
            member_expiring = True
        if today > member.expiry_date:
            member_expired = True

    return render_to_response('members/membership/membership.html',{'direct_debit':direct_debit,'member_expiring':member_expiring,'member_expired':member_expired},context_instance=RequestContext(request))

@members_only
def update_direct_debit(request):

    member = get_object_or_404(Member,user=request.user)

    try:
        direct_debit = MemberDirectDebit.objects.get(status='current',member=member)
    except:
        messages.error(request,'You haven\'t got A Direct Debit setup yet')
        return HttpResponseRedirect(reverse('account_membership'))

    direct_debit_form = DirectDebitForm(instance=direct_debit)

    old_sort_code = direct_debit.sort_code
    old_ac_no = direct_debit.ac_no
    old_ac_name = direct_debit.ac_name

    if request.POST:
        direct_debit_form = DirectDebitForm(request.POST,instance=direct_debit)

        if direct_debit_form.is_valid():

            direct_debit_form.save()

            if direct_debit.sort_code != old_sort_code:
                direct_debit.old_sort_code = old_sort_code
            if direct_debit.sort_code != old_ac_no:
                direct_debit.old_ac_no = old_ac_no
            if direct_debit.sort_code != old_ac_name:
                direct_debit.old_ac_name = old_ac_name
            direct_debit.save()

            direct_debit_updated.send(sender=None,request=request,member=member,direct_debit=direct_debit)

            messages.success(request,'Your Direct Debit details have been updated')

            return HttpResponseRedirect(reverse('account_membership'))

        else:
            messages.error(request,'Could not update your Direct Debit details')

    return render_to_response('members/membership/update-direct-debit.html',{'direct_debit':direct_debit,'direct_debit_form':direct_debit_form},context_instance=RequestContext(request))


@members_only
def renew_membership(request):

    member = get_object_or_404(Member,user=request.user,user_type='member',approved=True)

    today = date.today()
    one_month = today+relativedelta(months=+1)

    member_expiring = False
    member_expired = False

    if member.expiry_date:
        if one_month >= member.expiry_date:
            member_expiring = True
        if today > member.expiry_date:
            member_expired = True

    try:
        direct_debit = MemberDirectDebit.objects.get(status='current',member=member)
        messages.success(request,'You have a Direct Debit associated with your membership, it will renew automatically.')
        return HttpResponseRedirect(reverse('account_membership'))
    except:
        pass

    try:
        content = ContentBlock.objects.get(slug='member-renewal-intro')
    except:
        content = False

    member = get_object_or_404(Member,user=request.user,user_type='member')

    update_user_form = UpdateUserForm(instance=member.user)
    update_personal_form = RegistrationFormPersonal(instance=member)
    update_personal_address_form = RegistrationFormPersonalAddress(instance=member)
    update_hospital_form = RegistrationFormHospital(instance=member)
    update_work_skip_form = RegistrationFormWorkSkip(instance=member)
    # update_other_societies_form = RegistrationFormOtherSocieties(instance=member)
    # update_areas_form = RegistrationFormAreas(instance=member)
    update_terms_form = RegistrationFormTerms(instance=member)

    if request.POST:

        forms = [update_personal_form,update_personal_address_form,update_hospital_form]
        updated_fields = find_updated_fields(request,member,update_user_form,forms)

        update_user_form = UpdateUserForm(request.POST,instance=member.user)
        update_personal_form = RegistrationFormPersonal(request.POST,instance=member)
        update_personal_address_form = RegistrationFormPersonalAddress(request.POST,instance=member)
        update_hospital_form = RegistrationFormHospital(request.POST,instance=member)
        update_work_skip_form = RegistrationFormWorkSkip(request.POST,instance=member)
        # update_other_societies_form = RegistrationFormOtherSocieties(request.POST,instance=member)
        # update_areas_form = RegistrationFormAreas(request.POST,instance=member)
        update_terms_form = RegistrationFormTerms(request.POST, instance=member)

        if update_user_form.is_valid() and update_personal_form.is_valid() and update_personal_address_form.is_valid() and update_terms_form.is_valid():

            if update_hospital_form.is_valid() or update_work_skip_form.is_valid():

                #try:

                update_user_form.save()
                update_personal_form.save()
                update_personal_address_form.save()
                if update_hospital_form.is_valid():
                    update_hospital_form.save()
                if update_work_skip_form.is_valid():
                    update_work_skip_form.save()
                # update_other_societies_form.save()
                # update_areas_form.save()
                update_terms_form.save()

                if updated_fields:
                    details_updated.send(sender=None,request=request,member=member,updated_fields=updated_fields)

                messages.success(request,'Your details have been updated')
                return HttpResponseRedirect(reverse('account_renew_payment'))

            #except:
            #    messages.error(request,'Sorry, could not update your profile')

    return render_to_response("members/membership/renew/renew.html",{'content':content,'member_expiring':member_expiring,'member_expired':member_expired,'update_user_form':update_user_form,'update_personal_form':update_personal_form,'update_personal_address_form':update_personal_address_form,'update_hospital_form':update_hospital_form,'update_work_skip_form':update_work_skip_form, 'update_terms_form':update_terms_form},context_instance=RequestContext(request))

@members_only
def renew_membership_payment(request):

    member = get_object_or_404(Member,user=request.user,user_type='member')
    #sort out the payment stuff here

    try:
        content = ContentBlock.objects.get(slug='member-renewal-payment')
    except:
        content = False

    try:
        direct_debit = MemberDirectDebit.objects.get(status='current',member=member)
        messages.success(request,'You have a Direct Debit associated with your membership, it will renew automatically.')
        return HttpResponseRedirect(reverse('account_membership'))
    except:
        pass

    if not member.expiry_date:
        messages.success(request,'Your membership is set to not expire, you do not need to renew.')
        return HttpResponseRedirect(reverse('account_membership'))
    else:
        year = member.expiry_date.year + 1

    if not member.member_type:
        messages.error(request,'Sorry, your membership does not have a type set, please contact an administrator for further information')
        return HttpResponseRedirect(reverse('account_membership'))
    else:
        cost = member.member_type.renewal_fee

    payment = Payment(member=member,type='renewal')
    payment.save()

    today = date.today()

    if settings.DEVELOPMENT:
        payment.invoice = "%s_Member_Renewal_%s_DEV" % (settings.WEBSITE_CODE,payment.id)
    else :
        payment.invoice = "%s_Member_Renewal_%s" % (settings.WEBSITE_CODE,payment.id)

    payment.save()

    paypal_dict = {
        "business": settings.PAYPAL_RECEIVER_EMAIL,
        "amount": cost,
        "custom": "renewal",
        "item_name": '%s Membership Renewal' % (settings.WEBSITE_NAME),
        "currency_code": 'GBP',
        "invoice": payment.invoice,
        "notify_url": "%s%s" % (settings.URL, reverse('paypal-ipn')),
        "return_url": "%s%s" % (settings.URL, reverse('account_renew_payment_complete')),
        "cancel_return": "%s%s" % (settings.URL, reverse('account_renew_payment_failure')),
    }

    if settings.URL == 'http://127.0.0.1:8000':
        paypal_dict['notify_url'] = "%s%s" % (settings.NGROK_URL, reverse('paypal-ipn'))

    paypal_form = PayPalEncryptedPaymentsForm(initial=paypal_dict)

    return render_to_response('members/membership/renew/renew-payment.html',{'content':content,'member':member,'paypal_form':paypal_form},context_instance=RequestContext(request))

@csrf_exempt
@members_only
def renew_membership_payment_complete(request):

    try:
        content = ContentBlock.objects.get(slug='member-renewal-confirmed')
    except:
        content = False

    return render_to_response('members/membership/renew/renew-payment-complete.html',{'content':content},context_instance=RequestContext(request))

@csrf_exempt
@members_only
def renew_membership_payment_failure(request):

    return render_to_response('members/membership/renew/renew-failure.html',{},context_instance=RequestContext(request))

@members_only
def renew_membership_invoice(request):

    raise Http404

    member = get_object_or_404(Member,user=request.user)

    try:
        content = ContentBlock.objects.get(slug='member-renewal-invoice')
    except ContentBlock.DoesNotExist:
        content = False

    try:
        direct_debit = MemberDirectDebit.objects.get(status='current',member=member)
        messages.success(request,'You have a Direct Debit associated with your membership, it will renew automatically.')
        return HttpResponseRedirect(reverse('account_membership'))
    except:
        pass

    if not member.expiry_date:
        messages.success(request,'Your membership is set to not expire, you do not need to renew')
        return HttpResponseRedirect(reverse('account_membership'))


    invoice_form = MemberRenewalInvoiceForm()

    if request.POST:
        invoice_form = MemberRenewalInvoiceForm(request.POST)

        if invoice_form.is_valid():
            #try:
            invoice = invoice_form.save(commit=False)
            invoice.member = member
            invoice.save()

            renewal_invoice_confirmation.send(sender=None,request=request,member=member,invoice=invoice)

            return HttpResponseRedirect(reverse('account_renew_invoice_complete'))

            #except:
            #    messages.error(request,'Could not save your invoice information')

    return render_to_response('members/membership/renew/invoice.html',{'content':content,'invoice_form':invoice_form},context_instance=RequestContext(request))


@members_only
def renew_membership_invoice_complete(request):

    member = get_object_or_404(Member,user=request.user)

    try:
        content = ContentBlock.objects.get(slug='member-renewal-invoice-complete')
    except ContentBlock.DoesNotExist:
        content = False

    return render_to_response('members/membership/renew/invoice-complete.html',{'content':content},context_instance=RequestContext(request))


@members_only
def renew_membership_direct_debit(request):

    member = get_object_or_404(Member,user=request.user)

    try:
        content = ContentBlock.objects.get(slug='member-renewal-direct-debit')
    except ContentBlock.DoesNotExist:
        content = False

    try:
        member_direct_debit = MemberDirectDebit.objects.get(member=member,status='approved')

        messages.success(request,'You already have a Direct Debit setup to handle your Membership Renewals')
        return HttpResponseRedirect(reverse('account_membership'))
    except MemberDirectDebit.DoesNotExist:
        member_direct_debit = False
        direct_debit_form = DirectDebitForm()

    if request.POST:

        if member_direct_debit:
            direct_debit_form = DirectDebitForm(request.POST,instance=member_direct_debit)
        else:
            direct_debit_form = DirectDebitForm(request.POST)

        if direct_debit_form.is_valid():

            errors = False

            if member_direct_debit:
                try:
                    direct_debit_form.save()

                    renewal_direct_debit_confirmation.send(sender=None,request=request,member=member,direct_debit=member_direct_debit)
                    return HttpResponseRedirect(reverse('account_renew_direct_debit_complete'))

                except:
                    messages.error(request,'Could not update your direct debit')

            else:
                try:
                    member_direct_debit = direct_debit_form.save(commit=False)
                    member_direct_debit.member = member
                    member_direct_debit.collection = 'A'
                    member_direct_debit.submission = '01'
                    member_direct_debit.type = 'UKDD'
                    member_direct_debit.save()

                    renewal_direct_debit_confirmation.send(sender=None,request=request,member=member,direct_debit=member_direct_debit)
                    return HttpResponseRedirect(reverse('account_renew_direct_debit_complete'))

                except:
                    messages.error(request,'Could not create the Direct Debit')

    return render_to_response('members/membership/renew/direct-debit.html',{'content':content,'direct_debit_form':direct_debit_form},context_instance=RequestContext(request))


@members_only
def renew_membership_direct_debit_complete(request):

    member = get_object_or_404(Member,user=request.user)

    try:
        content = ContentBlock.objects.get(slug='member-renewal-direct-debit-confirm')
    except ContentBlock.DoesNotExist:
        content = False

    return render_to_response('members/membership/renew/direct-debit-confirm.html',{'content':content},context_instance=RequestContext(request))

@members_only
def my_receipts(request):

    member = get_object_or_404(Member,user=request.user)
    receipts = Receipt.objects.filter(member=member).order_by('-created')

    receipt_activity = UserActivity.objects.filter(type='account-notification',member=member)
    for activity in receipt_activity:
        activity.read = True
        activity.save()

    return render_to_response('members/receipts/my-receipts.html',{'receipts':receipts},context_instance=RequestContext(request))

def view_receipt_pdf(request,receipt_key):

    receipt = get_object_or_404(Receipt,unique_key=receipt_key)

    return render_to_response('members/receipts/view-receipt-pdf.html',{'receipt':receipt},context_instance=RequestContext(request))

@members_only
def my_certificates(request):

    member = get_object_or_404(Member,user=request.user)
    certificates = Certificate.objects.filter(member=member).order_by('-created')

    certificate_activity = UserActivity.objects.filter(type='certificate-notification',member=member)
    for activity in certificate_activity:
        activity.read = True
        activity.save()

    return render_to_response('members/certificates/my-certificates.html',{'certificates':certificates},context_instance=RequestContext(request))

def view_cert_pdf(request,certificate_id):

    certificate = get_object_or_404(Certificate,id=certificate_id)

    #return render_to_response('members/certificates/view-cert-pdf.html',{'certificate':certificate},context_instance=RequestContext(request))

    html = loader.render_to_string('members/certificates/view-cert-pdf.html',{'certificate':certificate},context_instance=RequestContext(request))

    client = pdfcrowd.Client("calmdigital", "dc33e7c4525620565185d0a00d90b8f0")
    client.setPageMargins('50','50','50','50')

    pdf = client.convertHtml(html)

     # set HTTP response headers
    response = HttpResponse(content_type="application/pdf")
    response["Cache-Control"] = "no-cache"
    response["Accept-Ranges"] = "none"
    response["Content-Disposition"] = "attachment; filename=certificate.pdf"

    response.write(pdf)

    return response



@members_only
def my_documents(request):

    member = get_object_or_404(Member,user=request.user)
    member_resources = MemberResource.objects.filter(member=member).order_by('-created')

    return render_to_response('public/members/account/my-documents.html',{'member':member,'member_resources':member_resources},context_instance=RequestContext(request))

@members_only
def remove_document(request,id):

    member = get_object_or_404(Member,user=request.user)
    member_resource = get_object_or_404(MemberResource,id=id)

    try:
        member_resource.delete()
        return HttpResponse('Ok')
    except:
        raise Http404
