from django.forms import ModelForm
from django import forms
from models import *

from django.core.validators import validate_email
from django.core.exceptions import ValidationError

#registration forms

class RegistrationFormMemberType(ModelForm):

    def __init__(self,*args,**kwargs):
        super(RegistrationFormMemberType,self).__init__(*args,**kwargs)
        self.fields['member_type'].queryset = MemberType.objects.filter(apply_online=True)
        self.fields['member_type'].required = True

    class Meta:
        model = Member
        fields = ('member_type',)

class RegistrationFormUser(ModelForm):

    def __init__(self,*args,**kwargs):
        super(RegistrationFormUser,self).__init__(*args,**kwargs)
        self.fields['email'].label = 'Email Address'
        self.fields['email'].help_text = ''

    class Meta:
        model = User
        fields = ('email',)

    def clean_email(self):
        email = self.cleaned_data.get('email')
        if email:
            users = User.objects.filter(email=email).exclude(email=self.instance.email)
            if users:
                raise forms.ValidationError(u'Sorry A User with this Email Address already exists')
        return email

class RegistrationFormPassword(forms.Form):

    password1 = forms.CharField(widget=forms.PasswordInput(), min_length=6, max_length=20, label='Password')
    password2 = forms.CharField(widget=forms.PasswordInput(), min_length=6, max_length=20, label='Confirm Password')

    def clean_password2(self):
        password1 = self.cleaned_data.get('password1')
        password2 = self.cleaned_data.get('password2')

        if password1 and password2:
            if password1 != password2:
                raise forms.ValidationError(u'Please ensure your passwords match')

class RegistrationFormPersonal(ModelForm):

    def __init__(self, *args, **kwargs):
        super(RegistrationFormPersonal, self).__init__(*args, **kwargs)
        self.fields['title'].required = True
        self.fields['given_name'].required = True
        self.fields['surname'].required = True
        self.fields['date_of_birth'].required = True
        self.fields['profession'].required = True

    class Meta:
        model = Member
        fields = ('title','given_name','surname','date_of_birth','gender','qualifications','profession','speciality')

class RegistrationFormHospital(ModelForm):

    def __init__(self, *args, **kwargs):

        super(RegistrationFormHospital, self).__init__(*args, **kwargs)
        self.fields['job_title'].required = True
        self.fields['hospital'].required = True
        self.fields['hospital_department'].required = True
        self.fields['hospital_address_1'].required = True
        self.fields['hospital_town'].required = True
        self.fields['hospital_postcode'].required = True
        self.fields['hospital_country'].required = True
        self.fields['hospital_phone'].required = True
        self.fields['hospital_email'].required = True

    class Meta:
        model = Member
        fields = ('job_title','hospital','hospital_department','hospital_address_1','hospital_address_2','hospital_town','hospital_county','hospital_country','hospital_postcode','hospital_phone','hospital_email')

    def clean_hospital_postcode(self):
        postcode = self.cleaned_data.get('hospital_postcode')
        country = self.cleaned_data.get('hospital_country')

        if country and not postcode :
            if country.iso_code != 'IE':
                raise forms.ValidationError(u'Please enter a valid postcode')

        return postcode

class RegistrationFormPersonalAddress(ModelForm):

    def __init__(self, *args, **kwargs):
        super(RegistrationFormPersonalAddress, self).__init__(*args, **kwargs)
        self.fields['address_1'].required = True
        self.fields['town'].required = True
        self.fields['country'].required = True
        self.fields['telephone'].required = True
        self.fields['preferred_mailing_address'].required = True

    class Meta:
        model = Member
        fields = ('address_1','address_2','town','country','postcode','personal_email','telephone','mobile','preferred_mailing_address')

    def clean_postcode(self):
        postcode = self.cleaned_data.get('postcode')
        country = self.cleaned_data.get('country')

        if country and not postcode:
            if country.iso_code != 'IE':
                raise forms.ValidationError(u'Please enter a valid postcode')

        return postcode

class RegistrationFormWorkSkip(ModelForm):

    def __init__(self, *args, **kwargs):
        super(RegistrationFormWorkSkip, self).__init__(*args, **kwargs)
        self.fields['no_work_address'].required = True

    class Meta:
        model = Member
        fields = ('no_work_address',)

class RegistrationFormSupport(ModelForm):

    #def __init__(self,*args,**kwargs):
    #    super(RegistrationFormSupport,self).__init__(*args,**kwargs)
    #    self.fields['referrer_email'].required = True
    #    self.fields['referrer_2_email'].required = True

    class Meta:
        model = Member
        fields = ('referrer_email',)

class RegistrationFormOtherSocieties(ModelForm):

    class Meta:
        model = Member
        fields = ('other_societies','other_societies_other')

class RegistrationFormDonation(ModelForm):

    class Meta:
        model = Member
        fields = ('donation','donation_amount',)

class RegistrationFormTerms(ModelForm):

    class Meta:
        model = Member
        fields = ('agree_terms',)

    def __init__(self,*args,**kwargs):
        super(RegistrationFormTerms,self).__init__(*args,**kwargs)
        self.fields['agree_terms'].required = True

class RegistrationFormAreas(ModelForm):

    class Meta:
        model = Member
        fields = ('areas_of_interest','areas_of_interest_other')

class RegistrationFormContact(ModelForm):

    def __init__(self, *args, **kwargs):
        super(RegistrationFormContact, self).__init__(*args, **kwargs)

    class Meta:
        model = Member
        fields = ('mailing_list','gift_aid')

class RegistrationFormGiftAid(ModelForm):

    def __init__(self,*args,**kwargs):
        super(RegistrationFormGiftAid,self).__init__(*args,**kwargs)
        self.fields['gift_aid_name'].required = True
        self.fields['gift_aid_address1'].required = True
        self.fields['gift_aid_town'].required = True
        self.fields['gift_aid_country'].required = True
        self.fields['gift_aid_postcode'].required = True

    class Meta:
        model = Member
        fields = ('gift_aid_name','gift_aid_address1','gift_aid_address2','gift_aid_town','gift_aid_county','gift_aid_country','gift_aid_postcode')


class RegistrationFormInvoice(ModelForm):

    def __init__(self,*args,**kwargs):
        super(RegistrationFormInvoice,self).__init__(*args,**kwargs)

    class Meta:
        model = Member
        fields = ('invoice_company_name','invoice_email')

class UpdateUserForm(ModelForm):

    def __init__(self,*args,**kwargs):
        super(UpdateUserForm,self).__init__(*args,**kwargs)
        self.fields['email'].required = True

    class Meta:
        model = User
        fields = ('email',)

    def clean_email(self):
        email = self.cleaned_data.get('email')
        if email:
            users = User.objects.filter(email=email).exclude(email=self.instance.email)
            if users:
                raise forms.ValidationError(u'Sorry A User with this Email Address already exists')

        return email

class UpdateDelegateForm(ModelForm):

    def __init__(self,*args,**kwargs):
        super(UpdateDelegateForm,self).__init__(*args,**kwargs)
        self.fields['given_name'].required = True
        self.fields['surname'].required = True
        self.fields['address_1'].required = True
        self.fields['town'].required = True
        self.fields['country'].required = True
        self.fields['postcode'].required = True
        self.fields['telephone'].required = True

    class Meta:
        model = Member
        fields = ('given_name','surname','address_1','address_2','town','county','country','postcode','telephone')


class UpdateFormDetails(ModelForm):

    def __init__(self, *args, **kwargs):
        super(UpdateFormDetails, self).__init__(*args, **kwargs)
        self.fields['profession'].required = True

    class Meta:
        model = Member
        fields = ('profession',)

class MemberRenewalInvoiceForm(ModelForm):

    class Meta:
        model = MemberRenewalInvoice
        exclude = ('member','paid',)


class MemberProfileImageForm(forms.Form):
    image = forms.ImageField(label='Browse For an Image')

class DirectDebitForm(ModelForm):

    class Meta:
        model = MemberDirectDebit
        fields = ('sort_code','ac_no','ac_name',)


#forms for password setting/resetting

class ForgotPasswordForm(forms.Form):
    email       = forms.CharField(max_length=50, label='Username/Email Address')

class MemberPasswordForm(forms.Form):
    password  = forms.CharField(widget=forms.PasswordInput, min_length=5, max_length=20)
    password2 = forms.CharField(widget=forms.PasswordInput, min_length=5, max_length=20, label="Confirm Password")

#email member

class EmailMemberForm(forms.Form):
    message = forms.CharField(widget=forms.widgets.Textarea(), label='Please enter your message')
