#Django core bits
from django.shortcuts import render_to_response, get_object_or_404
from django.template import RequestContext, loader, Context
from django.contrib.auth.decorators import login_required, permission_required
from django.db.models import Q
from django.contrib.sites.models import Site
from django.conf import settings
from django.http import HttpResponseRedirect, Http404, HttpResponse
from django.core.urlresolvers import reverse
from django.contrib import messages
from django.contrib.auth.models import User, Group
from django.template.defaultfilters import slugify
from django.core.mail import EmailMessage
from django.views.decorators.csrf import csrf_exempt

from datetime import datetime,date,time

import pdfcrowd

#models
from modules.pages.models import *
from modules.blocks.models import *
from modules.resources.models import Resource

from modules.payments.models import *
from modules.payments.functions import *

from models import *
from forms import *
from functions import *
from signals import *

from modules.core.functions import *

from modules.blocks.models import *

from paypal.standard.forms import PayPalEncryptedPaymentsForm

def register(request):

    if request.user.is_authenticated():
        messages.error(request,'Sorry, you are already logged in.')
        return HttpResponseRedirect(reverse('account_home'))

    try:
        content_block = ContentBlock.objects.get(slug='registration-form-intro')
    except:
        content_block = False

    try:
        country = Country.objects.get(name='United Kingdom')
    except:
        country = False

    registration_form_user = RegistrationFormUser()
    registration_form_password = RegistrationFormPassword()
    registration_form_personal = RegistrationFormPersonal()
    registration_form_member_type = RegistrationFormMemberType()
    registration_form_personal_address = RegistrationFormPersonalAddress(initial={'country':country})
    registration_form_hospital = RegistrationFormHospital(initial={'hospital_country':country})
    registration_form_work_skip = RegistrationFormWorkSkip()
    registration_form_support = RegistrationFormSupport()
    registration_form_other_societies = RegistrationFormOtherSocieties()
    registration_form_areas = RegistrationFormAreas()
    registration_form_donation = RegistrationFormDonation()
    registration_form_contact = RegistrationFormContact()
    registration_form_terms = RegistrationFormTerms()

    if request.POST:

        registration_form_user = RegistrationFormUser(request.POST)
        registration_form_password = RegistrationFormPassword(request.POST)
        registration_form_personal = RegistrationFormPersonal(request.POST)
        registration_form_member_type = RegistrationFormMemberType(request.POST)
        registration_form_personal_address = RegistrationFormPersonalAddress(request.POST)
        registration_form_hospital = RegistrationFormHospital(request.POST)
        registration_form_work_skip = RegistrationFormWorkSkip(request.POST)
        registration_form_support = RegistrationFormSupport(request.POST,request.FILES)
        #registration_form_other_societies = RegistrationFormOtherSocieties(request.POST)
        #registration_form_areas = RegistrationFormAreas(request.POST)
        registration_form_donation = RegistrationFormDonation(request.POST)
        registration_form_contact = RegistrationFormContact(request.POST)
        registration_form_terms = RegistrationFormTerms(request.POST)

        member = register_member(request,True)
        if member:

            member.unique_key = random_string_unique(100,Member,'unique_key')
            member.membership_number = get_next_membership_number()
            member.save()

            request.session['member_key'] = member.unique_key

            if member.gift_aid:
                return HttpResponseRedirect(reverse('register_gift_aid'))
            else:
                return HttpResponseRedirect(reverse('register_payment'))

    return render(request,'public/registration/register.html',{'content_block':content_block,'registration_form_user':registration_form_user,'registration_form_password':registration_form_password,'registration_form_personal':registration_form_personal,'registration_form_member_type':registration_form_member_type,'registration_form_personal_address':registration_form_personal_address,'registration_form_hospital':registration_form_hospital,'registration_form_work_skip':registration_form_work_skip,'registration_form_support':registration_form_support,'registration_form_other_societies':registration_form_other_societies,'registration_form_areas':registration_form_areas,'registration_form_donation':registration_form_donation,'registration_form_contact':registration_form_contact, 'registration_form_terms':registration_form_terms})


def register_gift_aid(request):

    member = False
    if request.session.get('member_key',False):
        try:
            member = Member.objects.get(unique_key=request.session['member_key'])
        except Member.DoesNotExist():
            pass

    if not member:
        messages.error(request,'Sorry, could not find the current applicant.')
        return HttpResponseRedirect(reverse('register'))

    registration_gift_aid_form = RegistrationFormGiftAid(instance=member,initial={'gift_aid_name':'%s %s' % (member.given_name,member.surname),'gift_aid_address1':member.address_1,'gift_aid_address2':member.address_2,'gift_aid_town':member.town,'gift_aid_county':member.county,'gift_aid_country':member.country,'gift_aid_postcode':member.postcode})
    if request.POST:
        registration_gift_aid_form = RegistrationFormGiftAid(request.POST,instance=member)
        if registration_gift_aid_form.is_valid():
            try:
                registration_gift_aid_form.save()

                messages.success(request,'Gift Aid Details saved')
                return HttpResponseRedirect(reverse('register_payment'))
            except:
                messages.error(request,'Could not save your Gift Aid Details')

    return render(request,'public/registration/register-gift-aid.html',{'member':member,'registration_gift_aid_form':registration_gift_aid_form})


def register_payment(request):

    member = False
    if request.session.get('member_key',False):
        try:
            member = Member.objects.get(unique_key=request.session['member_key'])
        except Member.DoesNotExist():
            pass

    if not member:
        messages.error(request,'Sorry, could not find the current applicant.')
        return HttpResponseRedirect(reverse('register'))

    if member.complete:
        messages.warning(request,'You have already paid for your membership')
        return HttpResponseRedirect(reverse('register_payment_complete'))

    try:
        content_block  = ContentBlock.objects.get(slug='registration-payment')
    except:
        content_block = False

    fee = member.get_registration_fee()
    if member.donation_amount:
        fee = fee + member.donation_amount

    if not member.member_type.direct_debit_only:
        payment = Payment(member=member,type='registration')
        payment.save()

        today = date.today()

        if settings.DEVELOPMENT:
            payment.invoice = "%s_Member_Registration_%s_DEV" % (settings.WEBSITE_CODE,payment.id)
        else :
            payment.invoice = "%s_Member_Registration_%s" % (settings.WEBSITE_CODE,payment.id)

        payment.save()

        paypal_dict = {
            "business": settings.PAYPAL_RECEIVER_EMAIL,
            "amount": fee,
            "custom": "registration",
            "item_name": '%s Membership Registration' % (settings.WEBSITE_NAME),
            "currency_code": 'GBP',
            "invoice": payment.invoice,
            "notify_url": "%s%s" % (settings.URL, reverse('paypal-ipn')),
            "return_url": "%s%s" % (settings.URL, reverse('register_payment_complete')),
            "cancel_return": "%s%s" % (settings.URL, reverse('register_payment_failure')),
        }

        if settings.URL == 'http://127.0.0.1:8000':
            paypal_dict['notify_url'] = "%s%s" % (settings.NGROK_URL, reverse('paypal-ipn'))

        paypal_form = PayPalEncryptedPaymentsForm(initial=paypal_dict)

    else:
        paypal_form = False

    return render_to_response('public/registration/payment.html',{'member':member,'content_block':content_block,'total':fee,'paypal_form':paypal_form},context_instance=RequestContext(request))

@csrf_exempt
def register_payment_complete(request):

    try:
        content_block  = ContentBlock.objects.get(slug='registration-payment-complete')
    except:
        content_block = False

    return render_to_response('public/registration/payment-complete.html',{'content_block':content_block},context_instance=RequestContext(request))

@csrf_exempt
def register_payment_failure(request):

    try:
        content_block = ContentBlock.objects.get(slug='registration-payment-failure')
    except:
        content_block = False

    return render_to_response('public/registration/payment-failure.html',{'content_block':content_block},context_instance=RequestContext(request))


def payment_invoice(request):

    raise Http404

    member = False
    if request.session.get('member_key',False):
        try:
            member = Member.objects.get(unique_key=request.session['member_key'])
        except Member.DoesNotExist():
            pass

    if not member:
        messages.error(request,'Sorry, could not find the current applicant.')
        return HttpResponseRedirect(reverse('register'))

    if member.complete:
        messages.warning(request,'Your details have already been sent for approval.')
        return HttpResponseRedirect(reverse('register'))

    try:
        content_block  = ContentBlock.objects.get(slug='registration-invoice')
    except:
        content_block = False

    invoice_form = RegistrationFormInvoice(instance=member)

    if request.POST:

        invoice_form = RegistrationFormInvoice(request.POST,instance=member)

        if invoice_form.is_valid():

            #try:
            invoice_form.save()
            member.complete = True
            member.payment_type = 'Invoice'
            member.save()

            #signal to confirm invoice
            registration_invoice_completed.send(sender=None,request=request,member=member)
            if member.referrer_key:
                registration_member_referrers.send(sender=None,request=request,member=member)

            return HttpResponseRedirect(reverse('register_payment_invoice_complete'))

            #except:
            #messages.error(request,'Could not process the form, please try again')

    return render_to_response('public/registration/payment-invoice.html',{'content_block':content_block,'invoice_form':invoice_form},context_instance=RequestContext(request))

def payment_direct_debit(request):

    try:
        content_block  = ContentBlock.objects.get(slug='registration-direct-debit')
    except:
        content_block = False

    member = False
    if request.session.get('member_key',False):
        try:
            member = Member.objects.get(unique_key=request.session['member_key'])
        except Member.DoesNotExist():
            pass

    if not member:
        messages.error(request,'Sorry, could not find the current applicant.')
        return HttpResponseRedirect(reverse('register'))

    if member.complete:
        messages.warning(request,'Your details have already been sent for approval.')
        return HttpResponseRedirect(reverse('register'))

    try:
        dd_form = Resource.objects.get(slug='direct-debit-form')
    except:
        dd_form = False

    member.complete = True
    member.payment_type = 'Direct Debit'
    member.save()

    #signal to confirm invoice
    registration_direct_debit_completed.send(sender=None,request=request,member=member,dd_form=dd_form)
    if member.referrer_key:
        registration_member_referrers.send(sender=None,request=request,member=member)

    #except:
    #messages.error(request,'Could not process the form, please try again')

    return render(request,'public/registration/payment-direct-debit.html',{'content_block':content_block,'dd_form':dd_form})

def payment_invoice_complete(request):

    member = False
    if request.session.get('member_key',False):
        try:
            member = Member.objects.get(unique_key=request.session['member_key'])
        except Member.DoesNotExist():
            pass

    if not member:
        messages.error(request,'Sorry, could not find the current applicant.')
        return HttpResponseRedirect(reverse('register'))

    try:
        content_block  = ContentBlock.objects.get(slug='registration-invoice-complete')
    except:
        content_block = False

    return render_to_response('public/registration/payment-invoice-complete.html',{'content_block':content_block},context_instance=RequestContext(request))

def referrer_confirm(request,referrer_key):

    try:
        content_block = ContentBlock.objects.get(slug='registration-referrer-confirm')
    except:
        content_block = False

    slot = False
    member = False

    try:
        member = Member.objects.get(referrer_key=referrer_key)
        member.referrer_approved = True
        member.save()
    except Member.DoesNotExist:
        return render_to_response('public/registration/referrer-not-found.html',{},context_instance=RequestContext(request))

    return render_to_response('public/registration/referrer-confirm.html',{'content_block':content_block},context_instance=RequestContext(request))
