#Django core bits
from django.shortcuts import render, render_to_response, get_object_or_404
from django.contrib.auth.decorators import login_required, permission_required
from django.http import HttpResponseRedirect, Http404, HttpResponse
from django.core.urlresolvers import reverse

from datetime import datetime,date,time

#Forms
from modules.members.adminforms import *

#Models
from modules.members.models import *
from modules.payments.models import *

#Others
import random,csv,string

from modules.core.decorators import *
from modules.core.functions import *
from modules.members.signals import *
from modules.members.functions import *

import pdfcrowd

@permission_required('admin_users.can_access_members')
def reports(request):

    member_types = MemberType.objects.all().order_by('name')

    return render(request,'admin/members/reports/reports.html',{'member_types':member_types })

@permission_required('admin_users.can_access_members')
def temp_emails(request):

    members = Member.objects.filter(temp_email=True,member_status='current',user_type='member')

    return render(request,'admin/members/reports/temp-emails.html',{'members':members})


@permission_required('admin_users.can_access_members')
def temp_emails_addresses(request):

    members = Member.objects.filter(temp_email=True,member_status='current',user_type='member')

    response = HttpResponse(content_type='text/csv')
    response['Content-Disposition'] = "attachment; filename=member-temp-emails-addresses.csv"

    writer = csv.writer(response)

    writer.writerow(['Membership Number','Title','Given Name','Surname','Email Address','Preferred Address','Address 1','Address 2','Town','County','Country','Postcode','Telephone','Job Title','Hospital','Hospital Department','Hospital Address 1','Hospital Address 2','Hospital Town','Hospital County','Hospital Country','Hospital Postcode','Hospital Telephone',])

    for member in members:
        if member.preferred_mailing_address == 'Residence':
            writer.writerow([unicode(s).encode("utf-8") for s in (member.membership_number,member.title,member.given_name,member.surname,member.user.email,member.get_preferred_mailing_address_display(),member.address_1,member.address_2,member.town,member.county,member.country,member.postcode,member.telephone,'','','','','','','','','','')])
        elif member.preferred_mailing_address == 'Work':
            writer.writerow([unicode(s).encode("utf-8") for s in (member.membership_number,member.title,member.given_name,member.surname,member.user.email,member.get_preferred_mailing_address_display(),'','','','','','','',member.job_title,member.hospital,member.hospital_department,member.hospital_address_1,member.hospital_address_2,member.hospital_town,member.hospital_county,member.hospital_country,member.hospital_postcode,member.hospital_phone)])
        else:
            writer.writerow([unicode(s).encode("utf-8") for s in (member.membership_number,member.title,member.given_name,member.surname,member.user.email,member.get_preferred_mailing_address_display(),member.address_1,member.address_2,member.town,member.county,member.country,member.postcode,member.telephone,member.job_title,member.hospital,member.hospital_department,member.hospital_address_1,member.hospital_address_2,member.hospital_town,member.hospital_county,member.hospital_country,member.hospital_postcode,member.hospital_phone)])

    return response

@permission_required('admin_users.can_access_members')
def no_subscriptions(request):

    members = Member.objects.filter(expiry_date__isnull=True,user_type='member',member_status='current',approved=True,member_type__renewal_fee__gt=0)

    return render(request,'admin/members/reports/no-subscriptions.html',{'members':members})


@permission_required('admin_users.can_access_members')
def suspended_members(request):

    members = Member.objects.filter(member_status='suspended',user_type='member')

    return render(request,'admin/members/reports/suspended-members.html',{'members':members})

@permission_required('admin_users.can_access_members')
def download_suspended_members(request):

    members = Member.objects.filter(member_status='suspended',user_type='member')

    response = HttpResponse(content_type='text/csv')
    response['Content-Disposition'] = "attachment; filename=suspended-members.csv"

    writer = csv.writer(response)

    writer.writerow(['Membership Number','Name','Email Address'])

    for member in members:
        writer.writerow([unicode(s).encode("utf-8") for s in (member.membership_number,"%s %s" % (member.given_name, member.surname),member.user.email)])

    return response

@permission_required('admin_users.can_access_members')
def lapsed_members(request):

    members = Member.objects.filter(member_status='lapsed',user_type='member')

    return render(request,'admin/members/reports/lapsed-members.html',{'members':members})

@permission_required('admin_users.can_access_members')
def download_lapsed_members(request):

    members = Member.objects.filter(member_status='suspended',user_type='member')

    response = HttpResponse(content_type='text/csv')
    response['Content-Disposition'] = "attachment; filename=lapsed-members.csv"

    writer = csv.writer(response)

    writer.writerow(['Membership Number','Name','Email Address'])

    for member in members:
        writer.writerow([unicode(s).encode("utf-8") for s in (member.membership_number,"%s %s" % (member.given_name, member.surname),member.user.email)])

    return response

@permission_required('admin_users.can_access_members')
def expired_members(request):

    today = date.today()
    members = Member.objects.filter(expiry_date__lte=today,user_type='member',member_status='current').order_by('expiry_date')

    return render(request,'admin/members/reports/expired-members.html',{'members':members})

@permission_required('admin_users.can_access_members')
def download_expired_members(request):

    today = date.today()
    members = Member.objects.filter(expiry_date__lte=today,user_type='member',member_status='current').order_by('expiry_date')

    response = HttpResponse(content_type='text/csv')
    response['Content-Disposition'] = "attachment; filename=expired-members.csv"

    writer = csv.writer(response)

    writer.writerow(['Membership Number','Name','Email Address','Rate','Amount Due'])

    for member in members:
        writer.writerow([unicode(s).encode("utf-8") for s in (member.membership_number,"%s %s" % (member.given_name, member.surname),member.user.email,member.member_type,member.get_next_renewal_cost())])

    return response

@permission_required('admin_users.can_access_members')
def expiring_members(request):

    today = date.today()
    two_months = today+relativedelta(months=+2)

    members = Member.objects.filter(expiry_date__lte=two_months,user_type='member',member_status='current').order_by('expiry_date')
    final_members = []
    for member in members:
        if not member.get_direct_debit():
            final_members.append(member)

    return render(request,'admin/members/reports/expiring-members.html',{'members':final_members})


@permission_required('admin_users.can_access_members')
def download_expiring_members(request):

    today = date.today()
    two_months = today+relativedelta(months=+2)

    members = Member.objects.filter(expiry_date__lte=two_months,user_type='member',member_status='current').order_by('expiry_date')
    final_members = []
    for member in members:
        if not member.get_direct_debit():
            final_members.append(member)

    response = HttpResponse(content_type='text/csv')
    response['Content-Disposition'] = "attachment; filename=expring-members.csv"

    writer = csv.writer(response)

    writer.writerow(['Membership Number','Name','Email Address','Rate','Expiry Date','Amount Due'])

    for member in final_members:
        writer.writerow([unicode(s).encode("utf-8") for s in (member.membership_number,"%s %s" % (member.given_name, member.surname),member.user.email,member.member_type,member.expiry_date,member.get_next_renewal_cost())])

    return response

@permission_required('admin_users.can_access_members')
def mark_lapsed(request,member_id):

    today = date.today()
    member = get_object_or_404(Member,id=member_id)

    if member.expiry_date <= today and member.user_type == 'member' and member.member_status =='current':

        member.member_status = 'lapsed'
        member.lapsed_date = today
        member.save()

        membership_lapsed.send(sender=None,request=request,member=member)

        messages.success(request,'Member has been marked as lapsed')

    else:
        messages.error(request,'Could not mark member as Lapsed')

    return HttpResponseRedirect(reverse('admin_members_expired_members'))

@permission_required('admin_users.can_access_members')
def download_addresses(request):

    members = Member.objects.filter(approved=True,member_status='current',user_type='member').order_by('surname')

    response = HttpResponse(content_type='text/csv')
    response['Content-Disposition'] = "attachment; filename=member-addresses.csv"

    writer = csv.writer(response)

    writer.writerow(['Membership Number','Title','Given Name','Surname','Email Address','Preferred Address','Address 1','Address 2','Town','County','Country','Postcode','Telephone','Job Title','Hospital','Hospital Department','Hospital Address 1','Hospital Address 2','Hospital Town','Hospital County','Hospital Country','Hospital Postcode','Hospital Telephone','Mailing List'])

    for member in members:
        if member.mailing_list:
            mailing_list = 'Yes'
        else:
            mailing_list = 'No'
        if member.preferred_mailing_address == 'Residence':
            writer.writerow([unicode(s).encode("utf-8") for s in (member.membership_number,member.title,member.given_name,member.surname,member.user.email,member.get_preferred_mailing_address_display(),member.address_1,member.address_2,member.town,member.county,member.country,member.postcode,member.telephone,'','','','','','','','','','',mailing_list)])
        elif member.preferred_mailing_address == 'Work':
            writer.writerow([unicode(s).encode("utf-8") for s in (member.membership_number,member.title,member.given_name,member.surname,member.user.email,member.get_preferred_mailing_address_display(),'','','','','','','',member.job_title,member.hospital,member.hospital_department,member.hospital_address_1,member.hospital_address_2,member.hospital_town,member.hospital_county,member.hospital_country,member.hospital_postcode,member.hospital_phone,mailing_list)])
        else:
            writer.writerow([unicode(s).encode("utf-8") for s in (member.membership_number,member.title,member.given_name,member.surname,member.user.email,member.get_preferred_mailing_address_display(),member.address_1,member.address_2,member.town,member.county,member.country,member.postcode,member.telephone,member.job_title,member.hospital,member.hospital_department,member.hospital_address_1,member.hospital_address_2,member.hospital_town,member.hospital_county,member.hospital_country,member.hospital_postcode,member.hospital_phone,mailing_list)])

    return response


@permission_required('admin_users.can_access_members')
def download_email_addresses(request):

    members = Member.objects.filter(approved=True,member_status='current',user_type='member').order_by('surname')

    response = HttpResponse(content_type='text/csv')
    response['Content-Disposition'] = "attachment; filename=member-email-addresses.csv"

    writer = csv.writer(response)

    writer.writerow(['Membership Number','Name','Email Address'])

    for member in members:
        writer.writerow([unicode(s).encode("utf-8") for s in (member.membership_number,"%s %s" % (member.given_name, member.surname),member.user.email)])

    return response

@permission_required('admin_users.can_access_members')
def download_type(request,type_id):

    type = get_object_or_404(MemberType,id=type_id)
    members = Member.objects.filter(approved=True,member_status='current',member_type=type).order_by('surname')

    response = HttpResponse(content_type='text/csv')
    response['Content-Disposition'] = "attachment; filename=type-members.csv"

    writer = csv.writer(response)

    writer.writerow(['Membership Number','Name','Email Address'])

    for member in members:
        writer.writerow([unicode(s).encode("utf-8") for s in (member.membership_number,"%s %s" % (member.given_name, member.surname),member.user.email)])

    return response

@permission_required('admin_users.can_access_members')
def download_owing_events(request):

    from modules.meeting_booking.models import *

    meetings = Meeting.objects.all()

    # Create the HttpResponse object with the appropriate CSV header.
    response = HttpResponse(content_type='text/csv')
    response['Content-Disposition'] = "attachment; filename=members_owing_events.csv"

    writer = csv.writer(response)

    writer.writerow(['Name','Membership Number','Event','Amount Owing'])

    for meeting in meetings:

        meeting_bookings = MeetingBooking.objects.filter(complete=True,status='pending',price_paid=0,meeting=meeting).order_by('-time')

        for meeting_booking in meeting_bookings:

            writer.writerow([unicode(s).encode("utf-8") for s in ("%s %s" % (meeting_booking.given_name,meeting_booking.surname),meeting_booking.member.membership_number,meeting,meeting_booking.get_amount_outstanding())])

    return response
