from django.dispatch import Signal

#registration
registration_payment_completed = Signal(providing_args=["request","member","receipt","payment"])
registration_invoice_completed = Signal(providing_args=["request","member","dd_form"])
registration_direct_debit_completed = Signal(providing_args=["request","member"])
registration_member_referrers = Signal(providing_args=["request","member"])

member_invoice_paid = Signal(providing_args=["request","member","receipt"])

#admin registration emails
member_admin_approved = Signal(providing_args=["request","member","certificate"])

#non member
non_member_registered = Signal(providing_args=["request","member","title"])

#members
bulk_email = Signal(providing_args=["request","admin_message"])

member_arrears_created = Signal(providing_args=["request","arrears"])
arrears_payment_complete = Signal(providing_args=["request","arrears"])

#renewal reminder emails
membership_renewal = Signal(providing_args=["request","member"])
membership_expired = Signal(providing_args=["request","member"])
membership_expired_reminder = Signal(providing_args=["request","member"])

#renewal
renewal_confirmation = Signal(providing_args=["request","member","subscription","method","receipt","certificate","notify_admin"])
renewal_invoice_confirmation = Signal(providing_args=["request","member","invoice"])
renewal_direct_debit_confirmation = Signal(providing_args=["request","member","direct_debit"])
direct_debit_updated = Signal(providing_args=["request","member","direct_debit"])

#details updated
details_updated = Signal(providing_args=["request","member","updated_fields"])
