#Django core bits
from django.shortcuts import render_to_response, get_object_or_404
from django.template import RequestContext, loader, Context
from django.contrib.auth.decorators import login_required, permission_required
from django.db.models import Q
from django.contrib.sites.models import Site
from django.conf import settings
from django.http import HttpResponseRedirect, Http404, HttpResponse
from django.core.urlresolvers import reverse
from django.contrib.auth.models import User, Group
from django.core.mail import EmailMessage
from django.contrib import messages
import csv

from models import *
from modules.members.models import *

from forms import *
from signals import *

@permission_required('admin_users.can_access_emails')
def bulk_emails(request):

    emails = AdminMessage.objects.filter(test_recipient='').order_by('-created')

    return render_to_response('admin/bulk-email/emails.html',{'emails':emails},context_instance=RequestContext(request))


@permission_required('admin_users.can_access_emails')
def view_bulk_email(request,email_id):

    bulk_email = AdminMessage.objects.get(id=email_id)

    return render_to_response('admin/bulk-email/view-bulk-email.html',{'bulk_email':bulk_email},context_instance=RequestContext(request))


@permission_required('admin_users.can_access_emails')
def resend_bulk_email(request,email_id):

    bulk_email = AdminMessage.objects.get(id=email_id)
    form = AdminMessageForm(instance=bulk_email)
    attachment_forms = []
    attachment_form = AdminMessageAttachmentForm(prefix='attachment_1')
    attachment_forms.append(attachment_form)

    return render_to_response('admin/bulk-email/resend-bulk-email.html',{'bulk_email':bulk_email,'attachment_forms':attachment_forms,'form':form},context_instance=RequestContext(request))

@permission_required('admin_users.can_access_emails')
def send_bulk_email(request):

    form = AdminMessageForm()

    if request.POST:
        form = AdminMessageForm(request.POST,request.FILES)

        attachment_errors = False
        attachment_forms = []
        posted_attachments = request.POST.getlist('attachments')
        for attachment_order in posted_attachments:
            attachment_form = AdminMessageAttachmentForm(request.POST,request.FILES,prefix='attachment_%s' % (attachment_order))
            attachment_forms.append(attachment_form)
            if not attachment_form.is_valid():
                attachment_errors = True

        if form.is_valid() and not attachment_errors:

            admin_message = form.save()
            attachment_order = 1
            for attachment_form in attachment_forms:
                email_attachment = attachment_form.save(commit=False)
                email_attachment.admin_message = admin_message
                email_attachment.order = attachment_order
                email_attachment.save()
                attachment_order = attachment_order + 1

            bulk_email.send(sender=None, request=request, admin_message=admin_message)

            if admin_message.test_recipient != '':
                messages.success(request,'Message has been sent to <strong>%s</strong>' % (admin_message.test_recipient))
            else:
                messages.success(request,'Message sent to Members')
                return HttpResponseRedirect(reverse('admin_emails_bulk_email'))

    attachment_forms = []
    attachment_form = AdminMessageAttachmentForm(prefix='attachment_1')
    attachment_forms.append(attachment_form)

    return render_to_response('admin/bulk-email/send-bulk-email.html',{'form':form,'attachment_forms':attachment_forms},context_instance=RequestContext(request))

@permission_required('admin_users.can_access_emails')
def emails(request):

    email_types = SentEmail.objects.values('email_type').distinct().order_by('email_type')

    return render_to_response('admin/emails/emails.html',{'email_types':email_types},context_instance=RequestContext(request))

@permission_required('admin_users.can_access_emails')
def type_emails(request,type_slug):

    emails = SentEmail.objects.filter(email_type=type_slug).order_by('-created')

    return render_to_response('admin/emails/category-emails.html',{'emails':emails,'email_type':type_slug},context_instance=RequestContext(request))

@permission_required('admin_users.can_access_emails')
def view_email(request,type_slug,email_id):

    email = get_object_or_404(SentEmail,id=email_id)

    return render_to_response('admin/emails/view-email.html',{'email':email,'email_type':type_slug},context_instance=RequestContext(request))


@permission_required('admin_users.can_access_emails')
def resend_email(request,type_slug,email_id):

    email = get_object_or_404(SentEmail,id=email_id)

    #try:
    resend_email_sig.send(sender=None,request=request,email=email)

    messages.success(request,'Email has been resent')

    #except:
    #    messages.error(request,'Could not resend email')

    return HttpResponseRedirect(reverse('admin_emails_type_emails',args=[type_slug]))

    return render_to_response('admin/emails/view-email.html',{'email':email,'email_type':type_slug},context_instance=RequestContext(request))


@permission_required('admin_users.can_access_emails')
def email_templates(request):

    email_templates = EmailTemplate.objects.filter(editable=True,email_type='member')

    return render_to_response('admin/emails/email-templates.html',{'email_templates':email_templates},context_instance=RequestContext(request))

@permission_required('admin_users.can_access_emails')
def edit_email_template(request,template_id):

    email_template = get_object_or_404(EmailTemplate,id=template_id)

    form = EmailTemplateForm(instance=email_template)

    if request.POST:
        form = EmailTemplateForm(request.POST,instance=email_template)

        if form.is_valid():

            try:
                form.save()
                messages.success(request,'Email Template has been saved')

                return HttpResponseRedirect(reverse('admin_emails_templates'))

            except:
                messages.error(request,'Could not save email template')

    return render_to_response('admin/emails/edit-email-template.html',{'email_template':email_template,'form':form},context_instance=RequestContext(request))

@permission_required('admin_users.can_access_emails')
def admin_templates(request):

    email_templates = EmailTemplate.objects.filter(email_type='admin',editable=True)

    return render_to_response('admin/emails/admin-templates.html',{'email_templates':email_templates},context_instance=RequestContext(request))

@permission_required('admin_users.can_access_emails')
def edit_admin_template(request,template_id):

    email_template = get_object_or_404(EmailTemplate,id=template_id)

    form = AdminTemplateForm(instance=email_template)

    if request.POST:
        form = AdminTemplateForm(request.POST,instance=email_template)

        if form.is_valid():

            try:
                form.save()
                messages.success(request,'Email Template has been saved')

                return HttpResponseRedirect(reverse('admin_emails_admin_templates'))

            except:
                messages.error(request,'Could not save email template')

    return render_to_response('admin/emails/edit-admin-template.html',{'email_template':email_template,'form':form},context_instance=RequestContext(request))
