# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import models, migrations


class Migration(migrations.Migration):

    dependencies = [
        ('members', '0003_auto_20150904_1057'),
    ]

    operations = [
        migrations.CreateModel(
            name='AdminMessage',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('sender', models.EmailField(max_length=100, verbose_name=b'From Email Address')),
                ('test_recipient', models.EmailField(max_length=100, null=True, verbose_name=b'Email Address to Test Message To', blank=True)),
                ('subject', models.CharField(max_length=200)),
                ('email_expired', models.BooleanField(default=False, verbose_name=b'Send to Expired Members only (Ignores Groups and Types above)')),
                ('message', models.TextField()),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('add_to_locker', models.BooleanField(default=True, verbose_name=b'Add this message to members lockers')),
                ('groups', models.ManyToManyField(to='members.MemberGroup', blank=True)),
                ('members', models.ManyToManyField(to='members.Member', blank=True)),
                ('types', models.ManyToManyField(to='members.MemberType', blank=True)),
            ],
        ),
        migrations.CreateModel(
            name='AdminMessageAttachment',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('order', models.IntegerField()),
                ('file', models.FileField(upload_to=b'emails/messages', null=True, verbose_name=b'Attachment', blank=True)),
                ('admin_message', models.ForeignKey(to='notifications.AdminMessage')),
            ],
        ),
        migrations.CreateModel(
            name='Contact',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('title', models.CharField(max_length=100)),
                ('from_name', models.CharField(max_length=100)),
                ('email_address', models.EmailField(max_length=254)),
            ],
        ),
        migrations.CreateModel(
            name='EmailTemplate',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('title', models.CharField(max_length=60)),
                ('key', models.SlugField(unique=True)),
                ('subject', models.CharField(max_length=100)),
                ('content', models.TextField()),
                ('enabled', models.BooleanField(default=True)),
                ('email_type', models.CharField(max_length=20, choices=[('admin', 'Admin'), ('member', 'Member')])),
                ('editable', models.BooleanField(default=False)),
                ('from_address', models.ForeignKey(related_name='from_address', to='notifications.Contact')),
                ('to_addresses', models.ManyToManyField(related_name='to_addresses', to='notifications.Contact', blank=True)),
            ],
            options={
                'ordering': ['title'],
            },
        ),
        migrations.CreateModel(
            name='SentEmail',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('email_type', models.CharField(max_length=50)),
                ('to_addresses', models.TextField()),
                ('bcc_addresses', models.TextField()),
                ('bcc_count', models.IntegerField()),
                ('from_address', models.CharField(max_length=200)),
                ('subject', models.CharField(max_length=200)),
                ('content', models.TextField()),
            ],
        ),
        migrations.CreateModel(
            name='SentEmailAttachment',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('attachment', models.FileField(upload_to=b'notifications/attachments')),
                ('order', models.IntegerField()),
                ('sent_email', models.ForeignKey(to='notifications.SentEmail')),
            ],
        ),
    ]
