from django.core.exceptions import PermissionDenied
from django.http import HttpResponseRedirect
from django.core.urlresolvers import reverse
from django.contrib import messages

from modules.members.models import *

from datetime import datetime,date,time

def pages_access_required(function):

    def _inner(request, *args, **kwargs):
        if request.user.has_perm('admin_users.can_access_pages') or request.user.has_perm('admin_users.can_edit_certain_pages'):
            return function(request, *args, **kwargs)
        else:
            messages.error(request,'Sorry, you cannot access this area of the admin.')
            return HttpResponseRedirect(reverse('login'))
        
    return _inner
    