#Django core bits
from django.shortcuts import render_to_response, get_object_or_404
from django.template import RequestContext, loader, Context
from django.contrib import messages
from django.contrib.auth.decorators import login_required, permission_required
from django.db.models import Q
from django.contrib.sites.models import Site
from django.conf import settings
from django.http import HttpResponseRedirect, Http404, HttpResponse
from django.core.urlresolvers import reverse
from django.core.mail import EmailMessage

from filetransfers.api import serve_file
import pdfcrowd, os

from datetime import datetime,date,time

from models import *
from modules.members.models import *

from modules.core.decorators import *
from modules.core.functions import *

import emails

@members_only
def paper_submissions(request):
    
    member = get_object_or_404(Member,user=request.user)
    submissions = PaperSubmission.objects.filter(member=member,complete=True).order_by('-submitted')
    
    return render_to_response('members/papers/paper-submissions.html',{'member':member,'submissions':submissions},context_instance=RequestContext(request))

@members_only
def papers(request):
    
    categories = PaperCategory.objects.all().order_by('name')
    
    return render(request,'members/papers/papers.html',{'categories':categories})

@members_only
def paper(request,paper_slug):
    
    member = get_object_or_404(Member,user=request.user)
    
    paper = get_object_or_404(Paper,slug=paper_slug,enabled=True)
    paper_questions = PaperQuestion.objects.filter(paper=paper,paper_section__isnull=True)
    paper_sections = PaperSection.objects.filter(paper=paper)
    
    try:
        paper_submission = PaperSubmission.objects.get(member=member,paper=paper)
    except PaperSubmission.DoesNotExist:
        paper_submission = PaperSubmission(member=member,paper=paper)
        paper_submission.save()
        
    question_submissions = PaperQuestionSubmission.objects.filter(submission=paper_submission)
        
    if request.POST:
        
        #raise Exception(request.POST)
    
        required_errors = []
        
        if request.POST['next'] == 'complete':
            
            assessment_sections = assessment.get_sections()
            for assessment_section in assessment_sections:
                questions = assessment_section.get_questions()
                for question in questions:
                    if question.required:
                        if not request.POST.get('question_%s' % (question.id)):
                            required_errors.append(question)
            
        answers = paper_submission.get_answers()
        for answer in answers:
            answer.delete()
            
        order = 1
        
        all_paper_questions = paper.get_all_questions()
        for question in all_paper_questions:
            if question.type == 'multi-select':
                if request.POST.getlist('question_%s' % (question.id)):
                    answers = request.POST.getlist('question_%s' % (question.id))
                    answer_text = ",".join(answers)
                    
                    correct_answers = question.answer.split(',')
                    
                    paper_question_submission = PaperQuestionSubmission(submission=paper_submission,question=question,question_name=question.name,answer=answer_text,order=order,correct=True)
                    paper_question_submission.save()
                    
                    if len(answers) == len(correct_answers):
                        for correct_answer in correct_answers:
                            if not correct_answer in answers:
                                paper_question_submission.correct = False
                    else:
                        paper_question_submission.correct = False
                        
                    paper_question_submission.save()
                        
                    order = order + 1
            else:
                if request.POST.get('question_%s' % (question.id)):
                    answer = request.POST['question_%s' % (question.id)]
                    paper_question_submission = PaperQuestionSubmission(submission=paper_submission,question=question,question_name=question.name,answer=answer,order=order)
                    if answer.lower() == question.answer.lower():
                        paper_question_submission.correct = True
                    paper_question_submission.save()
                    order = order + 1
        
        if request.POST['next'] == 'save':
            paper_submission.save()    
            messages.success(request,'Your answers have been saved.')
            
        else :
            
            if paper.pass_percentage > 0 : 
                
                #check to see if submission score is okay
                
                submission_percentage = paper_submission.get_percentage()

                if submission_percentage < paper.pass_percentage:
                    
                    messages.error(request,'You have not answered the required number of questions correctly, please try again')
                
                    incorrect_questions = paper_submission.get_incorrect_questions()
                    for incorrect_question in incorrect_questions:
                        messages.error(request,'You have answered question <strong>%s</strong> Incorrectly' % (incorrect_question))
                    
                    return render_to_response('members/papers/paper.html',{'paper':paper, 'paper_questions':paper_questions,'paper_sections':paper_sections,'paper_submission':paper_submission,'question_submissions':question_submissions,'incorrect_questions':incorrect_questions},context_instance=RequestContext(request))
                
            
            paper_submission.complete = True    
            paper_submission.submitted = datetime.now()
            paper_submission.save()
            
            try:
                # create an API client instance
                client = pdfcrowd.Client("calmdigital", "dc33e7c4525620565185d0a00d90b8f0")
                client.setPageMargins('50','50','50','50')
                client.setPageWidth('297mm')
                client.setPageHeight('210mm')
        
                # convert an HTML string and save the result to a file
                output_file = open(os.path.join(settings.PRIVATE_FILES, 'certificates/cpd_certificate_%s.pdf' % (paper_submission.id)), 'wb')
                #client.convertURI('%s%s' % (request.META['HTTP_HOST'],reverse('papers_download_certificate',args=[paper_submission.id])),output_file)
                certificate_html = loader.render_to_string('public/papers/paper-certificate.html',{'paper':paper,'paper_submission':paper_submission},context_instance=RequestContext(request))
                client.client.convertHtml(certificate_html)
                output_file.close()
        
                paper_submission.certificate = 'certificates/cpd_certificate_%s.pdf' % (paper_submission.id)
                paper_submission.save()
            
            except:
                pass
                
            emails.send_paper_submitted(request=request,paper_submission=paper_submission)
                
            return HttpResponseRedirect(reverse('papers_paper_complete',args=[paper.slug]))

    return render_to_response('members/papers/paper.html',{'paper':paper,'paper_questions':paper_questions,'paper_sections':paper_sections,'paper_submission':paper_submission,'question_submissions':question_submissions},context_instance=RequestContext(request))
    
def paper_download(request,paper_slug):
    
    member = get_object_or_404(Member,user=request.user)
    paper = get_object_or_404(Paper,slug=paper_slug)
    
    return serve_file(request,paper.pdf_file)

@members_only
def paper_complete(request,paper_slug):
    
    paper = get_object_or_404(Paper,slug=paper_slug)
    member = get_object_or_404(Member,user=request.user)
    
    try:
        paper_submission = PaperSubmission.objects.get(member=member,paper=paper,complete=True)
    except PaperSubmission.DoesNotExist:
        messages.error(request,'Sorry, you have not completed this paper yet')
        return HttpResponseRedirect(reverse('papers_paper',args=[paper.slug]))
        
    return render_to_response('members/papers/paper-complete.html',{'paper':paper,'paper_submission':paper_submission},context_instance=RequestContext(request))
    
@members_only
def paper_download_certificate(request,submission_id):
    
    member = get_object_or_404(Member,user=request.user)
    submission = get_object_or_404(PaperSubmission,id=submission_id,member=member)
    
    return serve_file(request,submission.certificate,save_as=True)