from django.conf.urls import patterns, include, url

urlpatterns = patterns('',

    url(r'^$', 'modules.papers.adminviews.papers', name='admin_papers'),
    
    url(r'^categories/$','modules.papers.adminviews.categories',name='admin_papers_categories'),
    url(r'^categories/add/$','modules.papers.adminviews.add_category',name='admin_papers_add_category'),
    url(r'^categories/edit/(?P<category_id>[-\d]+)/$','modules.papers.adminviews.edit_category',name='admin_papers_edit_category'),
    url(r'^categories/delete/(?P<category_id>[-\d]+)/$','modules.papers.adminviews.delete_category',name='admin_papers_delete_category'),
    
    url(r'^add/$','modules.papers.adminviews.add_paper',name='admin_papers_add_paper'),
    url(r'^edit/(?P<paper_id>[-\d]+)/$','modules.papers.adminviews.edit_paper',name='admin_papers_edit_paper'),
    url(r'^delete/(?P<paper_id>[-\d]+)/$','modules.papers.adminviews.delete_paper',name='admin_papers_delete_paper'),
    
    url(r'^paper/(?P<paper_id>[-\d]+)/download/$','modules.papers.adminviews.download_paper',name='admin_papers_download_paper'),
    url(r'^paper/(?P<paper_id>[-\d]+)/preview-certificate/$','modules.papers.adminviews.preview_certificate',name='admin_papers_preview_certificate'),
    url(r'^paper/(?P<paper_id>[-\d]+)/preview-certificate-pdf/$','modules.papers.adminviews.preview_certificate_pdf',name='admin_papers_preview_certificate_pdf'),
    
    url(r'^paper/(?P<paper_id>[-\d]+)/questions/$','modules.papers.adminviews.questions',name='admin_papers_questions'),
    url(r'^paper/(?P<paper_id>[-\d]+)/questions/upload-data/$','modules.papers.adminviews.upload_questions',name='admin_papers_upload_questions'),
    url(r'^paper/(?P<paper_id>[-\d]+)/questions/reorder/$','modules.papers.adminviews.reorder_questions',name='admin_papers_reorder_questions'),
    url(r'^paper/(?P<paper_id>[-\d]+)/questions/add/$','modules.papers.adminviews.add_question',name='admin_papers_add_question'),
    url(r'^paper/(?P<paper_id>[-\d]+)/questions/(?P<question_id>[-\d]+)/edit/$','modules.papers.adminviews.edit_question',name='admin_papers_edit_question'),
    url(r'^paper/(?P<paper_id>[-\d]+)/questions/(?P<question_id>[-\d]+)/delete/$','modules.papers.adminviews.delete_question',name='admin_papers_delete_question'),
    
    url(r'^paper/(?P<paper_id>[-\d]+)/submissions/$','modules.papers.adminviews.submissions',name='admin_papers_submissions'),
    url(r'^paper/(?P<paper_id>[-\d]+)/submissions/download/$','modules.papers.adminviews.download_submissions',name='admin_papers_download_submissions'),
    url(r'^paper/(?P<paper_id>[-\d]+)/submissions/(?P<submission_id>[-\d]+)/view/$','modules.papers.adminviews.view_submission',name='admin_papers_view_submission'),
    url(r'^paper/(?P<paper_id>[-\d]+)/submissions/(?P<submission_id>[-\d]+)/download-certificate/$','modules.papers.adminviews.download_certificate_submission',name='admin_papers_download_certificate_submission'),
    url(r'^paper/(?P<paper_id>[-\d]+)/submissions/(?P<submission_id>[-\d]+)/delete/$','modules.papers.adminviews.delete_submission',name='admin_papers_delete_submission'),


)