from models import *
from modules.notifications.models import *
from django.core.mail import EmailMessage

def send_paper_submitted(request,paper_submission):

    paper = paper_submission.paper

    message = """
<p>Dear Member</p>

<p>Your submission to the paper <strong>%s</strong> has been completed.</p>

<p>Please find attached your certificate, to confirm your CPD points.</p>

<p>This is an automatic email generated by the PSGBI website.</p>""" % (paper.name)

    msg = EmailMessage('PSGBI - Your Certificate', message, 'noreply@psgbi.org', [paper_submission.member.user.email])
    if paper_submission.certificate:
        msg.attach_file(paper_submission.certificate.path)
    msg.content_subtype = "html"

    msg.send()

    admin_message = """

<p><strong>%s %s</strong> has completed a submission to the paper <strong>%s</strong> on the PSGBI website.</p>

<p>To view this submission, please go to <a href="https://%s%s">https://%s%s</a></p>

<p>This is an automatic email generated by the PSGBI website.</p>""" % (paper_submission.member.given_name,paper_submission.member.surname,paper.name,request.META['HTTP_HOST'],reverse('admin_papers_view_submission',args=[paper.id,paper_submission.id]),request.META['HTTP_HOST'],reverse('admin_papers_view_submission',args=[paper.id,paper_submission.id]))

    msg = EmailMessage('PSGBI - A Submission has Been Made', admin_message,  'noreply@psgbi.org',['daniel@calmdigital.com'])
    msg.content_subtype = "html"

    msg.send()
