from django.forms import ModelForm
from django import forms

from models import *

class PaperForm(ModelForm):
    
    class Meta:
        model = Paper
        fields = ('name','category','subtitle','content_left','content_right','pdf_file','external_url','embed_code','cpd_credits','pass_percentage','enabled')

class PaperCategoryForm(ModelForm):
    
    class Meta:
        model = PaperCategory
        fields = ('name','order')
        

class PaperQuestionForm(ModelForm):
    
    class Meta:
        model = PaperQuestion
        fields = ('name','type','options','answer')
        
        
class UploadPaperQuestionsForm(forms.Form):
    
    file = forms.FileField(help_text='Upload your completed question template here, must be CSV file format.')