# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import models, migrations
import django.db.models.deletion
import django.core.files.storage


class Migration(migrations.Migration):

    dependencies = [
        ('members', '0003_auto_20150904_1057'),
    ]

    operations = [
        migrations.CreateModel(
            name='Paper',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('name', models.CharField(max_length=100)),
                ('slug', models.SlugField(unique=True)),
                ('subtitle', models.TextField(null=True, blank=True)),
                ('content_left', models.TextField(blank=True)),
                ('content_right', models.TextField(blank=True)),
                ('pdf_file', models.FileField(storage=django.core.files.storage.FileSystemStorage(location=b'/Applications/MAMP/htdocs/psgbi/private'), upload_to=b'papers', blank=True)),
                ('external_url', models.CharField(help_text=b'Paste the external url above', max_length=200, null=True, blank=True)),
                ('embed_code', models.TextField(help_text=b'Paste your embed code above', blank=True)),
                ('cpd_credits', models.IntegerField(default=0)),
                ('pass_percentage', models.IntegerField(default=0)),
                ('enabled', models.BooleanField(default=False)),
            ],
        ),
        migrations.CreateModel(
            name='PaperCategory',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('name', models.CharField(max_length=100)),
                ('order', models.IntegerField(default=0)),
            ],
        ),
        migrations.CreateModel(
            name='PaperQuestion',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('name', models.TextField(max_length=200, verbose_name=b'Question')),
                ('type', models.CharField(max_length=200, choices=[('select', b'Selection (Choose One)'), ('multi-select', b'Selection (Choose Multiple)'), ('true-false', b'True or False')])),
                ('required', models.BooleanField(default=True)),
                ('order', models.IntegerField()),
                ('options', models.TextField(null=True, blank=True)),
                ('answer', models.TextField(null=True, blank=True)),
                ('paper', models.ForeignKey(to='papers.Paper')),
            ],
            options={
                'ordering': ['paper_section__order', 'order'],
            },
        ),
        migrations.CreateModel(
            name='PaperQuestionSubmission',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('question_name', models.TextField()),
                ('answer', models.TextField(blank=True)),
                ('correct', models.BooleanField(default=False)),
                ('order', models.IntegerField()),
                ('question', models.ForeignKey(on_delete=django.db.models.deletion.SET_NULL, blank=True, to='papers.PaperQuestion', null=True)),
            ],
        ),
        migrations.CreateModel(
            name='PaperSection',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('name', models.CharField(max_length=200)),
                ('order', models.IntegerField()),
                ('paper', models.ForeignKey(to='papers.Paper')),
            ],
            options={
                'ordering': ['order'],
            },
        ),
        migrations.CreateModel(
            name='PaperSubmission',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('submitted', models.DateTimeField(null=True, blank=True)),
                ('complete', models.BooleanField(default=False)),
                ('attempt', models.IntegerField(default=0)),
                ('last_saved', models.DateTimeField(auto_now=True)),
                ('certificate', models.FileField(storage=django.core.files.storage.FileSystemStorage(location=b'/Applications/MAMP/htdocs/psgbi/private'), null=True, upload_to=b'cetificates', blank=True)),
                ('member', models.ForeignKey(to='members.Member')),
                ('paper', models.ForeignKey(to='papers.Paper')),
            ],
            options={
                'ordering': ['-last_saved'],
            },
        ),
        migrations.AddField(
            model_name='paperquestionsubmission',
            name='submission',
            field=models.ForeignKey(to='papers.PaperSubmission'),
        ),
        migrations.AddField(
            model_name='paperquestion',
            name='paper_section',
            field=models.ForeignKey(blank=True, to='papers.PaperSection', null=True),
        ),
        migrations.AddField(
            model_name='paper',
            name='category',
            field=models.ForeignKey(to='papers.PaperCategory'),
        ),
    ]
