#Django core bits
from django.shortcuts import render_to_response, get_object_or_404
from django.template import RequestContext, loader, Context
from django.contrib.auth.decorators import login_required, permission_required
from django.db.models import Q
from django.contrib.sites.models import Site
from django.conf import settings
from django.http import HttpResponseRedirect, Http404, HttpResponse
from django.core.urlresolvers import reverse
from django.contrib.auth.models import User, Group
from django.core.mail import EmailMessage
from django.contrib import messages

from datetime import datetime,date,time

#Models
from models import *
from modules.meeting_booking.models import *
from modules.payments.models import *

#Others
import random,csv,string
from django.template.defaultfilters import slugify
from django.core.paginator import Paginator

from modules.core.decorators import *
from modules.core.functions import *

@permission_required('admin_users.can_access_members')
def payments(request):
    
    all_payments = Payment.objects.all().exclude(status='pending').order_by('-created')
    paginated_payments = Paginator(all_payments,30)
    
    page = request.GET.get('page')
    try:
        payments = paginated_payments.page(page)
    except:
        payments = paginated_payments.page(1)

    return render_to_response('admin/payments/payments.html',{'payments':payments,'paginated_payments':paginated_payments},context_instance=RequestContext(request))

@permission_required('admin_users.can_access_members')    
def type(request,type_slug):
    
    all_payments = Payment.objects.filter(type=type_slug).order_by('-created')
    paginated_payments = Paginator(all_payments,30)
    
    page = request.GET.get('page')
    try:
        payments = paginated_payments.page(page)
    except:
        payments = paginated_payments.page(1)
        
    if type_slug == 'registration':
        type_name = 'Member Registrations'
    elif type_slug == 'renewal':
        type_name = 'Membership Renewals'
    elif type_slug == 'arrears':
        type_name = 'Membership Arrears'
    else:
        type_name = 'Meeting Bookings'
    
    return render_to_response('admin/payments/payment-type.html',{'type_name':type_name,'type_slug':type_slug,'payments':payments,'paginated_payments':paginated_payments},context_instance=RequestContext(request))
    
    
@permission_required('admin_users.can_access_members')
def type_download(request,type_slug):
    
    payments = Payment.objects.filter(type=type_slug).order_by('-created')
    
    response = HttpResponse(content_type='text/csv')
    response['Content-Disposition'] = "attachment; filename=%s.csv" % (type_slug)

    writer = csv.writer(response)
    
    writer.writerow(['Name','Type','Created','Status','Price'])
    
    for payment in payments:
        
        if payment.type == 'meeting-booking':
            if payment.meeting_booking:
                name = "%s %s" % (payment.meeting_booking.given_name, payment.meeting_booking.surname)
            else:
                name = payment.member
        else:
            name = payment.member
            
        if payment.type == 'meeting-booking':
            if payment.meeting_booking:
                type = "%s" % (payment.meeting_booking.meeting)
            else:
                type = "Meeting Booking (Deleted)"
        elif payment.type == 'arrears':
            type = payment.arrears.name
        else:
            type = payment.get_type_display()
        
        writer.writerow([unicode(s).encode("utf-8") for s in (name,type,payment.created,payment.get_status_display(),payment.amount)])
    
    return response
    
    
@permission_required('admin_users.can_access_members')
def payment(request,payment_id):
    
    payment = get_object_or_404(Payment,id=payment_id)
    
    return render_to_response('admin/payments/payment.html',{'payment':payment},context_instance=RequestContext(request))