# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import models, migrations
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('abstracts', '0001_initial'),
        ('members', '0003_auto_20150904_1057'),
        ('donations', '0001_initial'),
        ('meeting_booking', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='Payment',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('type', models.CharField(max_length=50, choices=[('registration', 'Registration'), ('renewal', 'Renewal'), ('arrears', 'Membership Arrears'), ('donation', 'Donation'), ('meeting-booking', 'Meeting Booking'), ('abstract-submission', 'Abstract Submission')])),
                ('status', models.CharField(default=b'pending', max_length=50, choices=[('pending', 'Pending'), ('complete', 'Complete'), ('rejected', 'Rejected')])),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('invoice', models.CharField(max_length=100, unique=True, null=True, blank=True)),
                ('amount', models.CharField(max_length=100, null=True, blank=True)),
                ('abstract_submission', models.ForeignKey(on_delete=django.db.models.deletion.SET_NULL, blank=True, to='abstracts.AbstractSubmission', null=True)),
                ('arrears', models.ForeignKey(on_delete=django.db.models.deletion.SET_NULL, blank=True, to='members.MemberArrears', null=True)),
                ('donation', models.ForeignKey(on_delete=django.db.models.deletion.SET_NULL, blank=True, to='donations.Donation', null=True)),
                ('meeting_booking', models.ForeignKey(on_delete=django.db.models.deletion.SET_NULL, blank=True, to='meeting_booking.MeetingBooking', null=True)),
                ('member', models.ForeignKey(on_delete=django.db.models.deletion.SET_NULL, blank=True, to='members.Member', null=True)),
            ],
        ),
    ]
