from django.db import models
from django.contrib.auth.models import User
from paypal.standard.ipn.signals import *
from django.template.loader import render_to_string
from django.template import RequestContext
from dateutil.relativedelta import relativedelta

import pdfcrowd

from modules.meeting_booking.signals import *
from modules.donations.signals import *

from modules.members.models import *

class Payment(models.Model):

    TYPE_CHOICES = (
        (u'registration',u'Registration'),
        (u'renewal',u'Renewal'),
        (u'arrears',u'Membership Arrears'),
        (u'donation',u'Donation'),
        (u'meeting-booking',u'Meeting Booking'),
        (u'abstract-submission',u'Abstract Submission'),
    )

    STATUS_CHOICES = (
        (u'pending',u'Pending'),
        (u'complete',u'Complete'),
        (u'rejected',u'Rejected'),
    )

    member    = models.ForeignKey('members.Member',blank=True,null=True,on_delete=models.SET_NULL)
    meeting_booking = models.ForeignKey('meeting_booking.MeetingBooking',blank=True,null=True,on_delete=models.SET_NULL)
    arrears         = models.ForeignKey('members.MemberArrears',blank=True,null=True,on_delete=models.SET_NULL)
    donation        = models.ForeignKey('donations.Donation',blank=True,null=True,on_delete=models.SET_NULL)
    abstract_submission = models.ForeignKey('abstracts.AbstractSubmission',blank=True,null=True,on_delete=models.SET_NULL)

    type            = models.CharField(max_length=50,choices=TYPE_CHOICES)
    status          = models.CharField(max_length=50,choices=STATUS_CHOICES,default='pending')
    created         = models.DateTimeField(auto_now_add=True)
    invoice         = models.CharField(max_length=100,unique=True,blank=True,null=True)

    amount          = models.CharField(max_length=100,blank=True,null=True)

    def __unicode__(self):
        if self.type == 'donation' and self.donation:
            return """%s %s""" % (self.donation.first_name,self.donation.surname)
        else:
            return """%s - %s""" % (self.created,self.status)

    def get_name(self):
        if self.member:
            return """%s %s""" % (self.member.given_name,self.member.surname)
        else:
            if self.type == 'meeting-booking' and self.meeting_booking:
                return """%s %s""" % (self.meeting_booking.given_name,self.meeting_booking.surname)
            elif self.type == 'donation' and self.donation:
                return """%s %s""" % (self.donation.first_name,self.donation.surname)
            else:
                return "Unknown"

    def is_member(self):

        if self.member:
            return True
        else:
            return False


    def payment_was_successful_handler(sender, **kwargs):
        ipn_obj = sender

        try:
            payment = Payment.objects.get(invoice=ipn_obj.invoice)
            if payment.status == 'pending':
                payment.status = 'complete'
                payment.amount = ipn_obj.mc_gross
                payment.save()
                if payment.type == 'meeting-booking':
                    try:
                        meeting_booking = payment.meeting_booking
                        meeting = meeting_booking.meeting

                        meeting_booking.complete = True
                        meeting_booking.paid = True
                        meeting_booking.price_paid = payment.amount
                        meeting_booking.save()

                        receipt_name = '%s' % (meeting)
                        receipt = Receipt(member=meeting_booking.member,meeting_booking=meeting_booking,type='meeting-booking',name=receipt_name,amount_paid=payment.amount,payment_type='Paypal')
                        receipt.unique_key = random_string_unique(20,Receipt,'unique_key')
                        receipt.save()

                        #try:
                        # create an API client instance
                        client = pdfcrowd.Client("calmdigital", "dc33e7c4525620565185d0a00d90b8f0")
                        client.setPageMargins('50','50','0','50')

                        # convert an HTML string and save the result to a file
                        output_file = open(os.path.join(settings.MEDIA_ROOT, 'members/receipts/meeting_booking_%s.pdf' % (receipt.id)), 'wb')

                        if settings.URL == 'http://127.0.0.1:8000':
                            client.convertURI('%s%s' % (settings.NGROK_URL,reverse('my_receipts_view_pdf',args=[receipt.unique_key])),output_file)
                        else:
                            client.convertURI('%s%s' % (settings.URL,reverse('my_receipts_view_pdf',args=[receipt.unique_key])),output_file)

                        output_file.close()
                        #except:
                        #    pass

                        receipt.file = 'members/receipts/meeting_booking_%s.pdf' % (receipt.id)
                        receipt.save()

                        meeting_booking_confirmation_email.send(sender=None, meeting_booking=meeting_booking,receipt=receipt)

                    except Exception, e:
                        payment.meeting_booking.complete = False
                        payment.meeting_booking.paid = False
                        payment.meeting_booking.save()
                        raise e
                elif payment.type == 'registration':
                    today = date.today()
                    year = today.year
                    expiry_date  = date(year+1,today.month,today.day)

                    member = payment.member
                    member.paid = True
                    member.complete = True
                    member.save()

                    receipt_name = '%s Membership Subscription (%s)' % (settings.WEBSITE_NAME,today.strftime('%B %Y'))
                    receipt = Receipt(member=member,name=receipt_name,start_date=today,amount_paid=payment.amount,payment_type='Credit Card')
                    receipt.unique_key = random_string_unique(20,Receipt,'unique_key')
                    receipt.save()

                    try:
                        client = pdfcrowd.Client("calmdigital", "dc33e7c4525620565185d0a00d90b8f0")
                        client.setPageMargins('50','50','0','50')
                        output_file = open(os.path.join(settings.MEDIA_ROOT, 'members/receipts/membership_payment_%s.pdf' % (receipt.id)), 'wb')
                        html = render_to_string('members/receipts/view-receipt-pdf.html',{'receipt':receipt})
                        client.convertHtml(html,output_file)
                        output_file.close()
                    except:
                        pass

                    receipt.file = 'members/receipts/membership_payment_%s.pdf' % (receipt.id)
                    receipt.save()

                    registration_payment_completed.send(sender=None,member=member,receipt=receipt,payment=payment)
                    if member.referrer_key:
                        registration_member_referrers.send(sender=None,member=member)

                    notification = UserActivity(member=member,type='account-notification',title='Membership Payment Complete',text='You have succesfully paid for your membership registration. <br/>Visit <a href="%s">My Receipts</a> to view your receipt.' % (reverse('my_receipts')))
                    notification.save()

                elif payment.type == 'renewal':

                    member = payment.member
                    member_type = member.member_type
                    current_expiry = member.expiry_date

                    start_date = date.today()

                    if member_type.subscription_length == '3-months':
                        end_date = start_date+relativedelta(months=+3,days=-1)
                    elif member_type.subscription_length == '6-months':
                        end_date = start_date+relativedelta(months=+6,days=-1)
                    else:
                        end_date = start_date+relativedelta(months=+12,days=-1)

                    member.expiry_date = end_date
                    member.save()

                    subscription_name = '%s Membership Subscription (%s)' % (member_type.name,start_date.strftime('%B %Y'))
                    invoice_to_name = '%s %s %s' % (member.get_title_display(),member.given_name,member.surname)

                    member_subscription = MemberSubscription(
                        member=member,
                        member_type=member_type,
                        subscription=subscription_name,
                        amount=payment.amount,
                        discount=0,
                        total=payment.amount,
                        invoice_to=invoice_to_name,
                        status='current',
                        start_date=start_date,
                        expiry_date=end_date,
                        invoice_created=date.today())
                    member_subscription.save()

                    receipt_name = '%s Membership Subscription (%s)' % (settings.WEBSITE_NAME,start_date.strftime('%B %Y'))
                    receipt = Receipt(member=member,name=receipt_name,start_date=start_date,amount_paid=payment.amount,payment_type='Credit Card')
                    receipt.save()

                    try:
                        client = pdfcrowd.Client("calmdigital", "dc33e7c4525620565185d0a00d90b8f0")
                        client.setPageMargins('50','50','0','50')
                        output_file = open(os.path.join(settings.MEDIA_ROOT, 'members/receipts/membership_renewal_%s.pdf' % (receipt.id)), 'wb')
                        html = render_to_string('members/receipts/view-receipt-pdf.html',{'receipt':receipt})
                        client.convertHtml(html,output_file)
                        output_file.close()
                    except:
                        pass

                    receipt.file = 'members/receipts/membership_renewal_%s.pdf' % (receipt.id)
                    receipt.save()

                    #create certificate pdf
                    certificate = Certificate(member=member,start_date=member_subscription.start_date,end_date=member_subscription.expiry_date)
                    certificate.save()

                    try:
                        client = pdfcrowd.Client("calmdigital", "dc33e7c4525620565185d0a00d90b8f0")
                        client.setPageMargins('50','50','0','50')
                        output_file = open(os.path.join(settings.MEDIA_ROOT, 'members/certificates/membership_certificate_%s.pdf' % (certificate.id)), 'wb')
                        html = render_to_string('members/certificates/view-cert-pdf.html',{'certificate':certificate})
                        client.convertHtml(html,output_file)
                        output_file.close()
                    except:
                        pass

                    certificate.file = 'members/certificates/membership_certificate_%s.pdf' % (certificate.id)
                    certificate.save()


                    renewal_confirmation.send(sender=None,member=member,subscription=member_subscription,method='Credit Card',receipt=receipt,certificate=certificate,notify_admin=True)

                    notification = UserActivity(member=member,type='account-notification',title='Membership Renewed',text='Your membership has been successfully renewed.<br/>Visit <a href="%s">My Receipts</a> to view your receipt.' % (reverse('my_receipts')))
                    notification.save()
                elif payment.type == 'donation':
                    donation = payment.donation

                    donation.complete = True
                    donation.save()

                    donation_confirmation_email.send(sender=None, donation=donation)

            else:
                pass

        except Exception, e:
            raise e
    payment_was_successful.connect(payment_was_successful_handler)
