# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='PPApplicant',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('order', models.IntegerField()),
                ('title', models.CharField(max_length=10)),
                ('forename', models.CharField(max_length=200)),
                ('surname', models.CharField(max_length=200)),
                ('age', models.CharField(max_length=10)),
                ('post_held', models.CharField(max_length=200)),
            ],
        ),
        migrations.CreateModel(
            name='PPApplication',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('title', models.CharField(max_length=10)),
                ('forename', models.CharField(max_length=200)),
                ('surname', models.CharField(max_length=200)),
                ('email', models.EmailField(max_length=254)),
                ('telephone', models.CharField(max_length=20)),
                ('institution', models.CharField(max_length=200)),
                ('address', models.TextField()),
                ('adm_institution', models.CharField(max_length=200, verbose_name=b'Name')),
                ('adm_institution_address', models.TextField()),
                ('title_of_study', models.CharField(max_length=200)),
                ('abstract', models.TextField(verbose_name=b'Abstract and methodological description of the study')),
                ('ethical_approval', models.TextField()),
                ('institutional_approval_information', models.TextField()),
                ('conirm_declaration', models.BooleanField(default=False)),
                ('hod_title', models.CharField(max_length=10)),
                ('hod_forename', models.CharField(max_length=200)),
                ('hod_surname', models.CharField(max_length=200)),
                ('hod_email', models.EmailField(max_length=254)),
                ('hod_telephone', models.CharField(max_length=20)),
                ('hod_institution', models.CharField(max_length=200)),
                ('hod_address', models.TextField()),
            ],
        ),
        migrations.CreateModel(
            name='PPForm',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('name', models.CharField(max_length=100)),
                ('slug', models.SlugField(max_length=102)),
                ('description', models.TextField(blank=True)),
                ('enabled', models.IntegerField()),
            ],
        ),
        migrations.CreateModel(
            name='PPFunding',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('order', models.IntegerField()),
                ('name', models.CharField(max_length=200)),
                ('amount', models.FloatField()),
                ('application', models.ForeignKey(to='pump_priming.PPApplication')),
            ],
        ),
        migrations.CreateModel(
            name='PPTimeTable',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('order', models.IntegerField()),
                ('application', models.ForeignKey(to='pump_priming.PPApplication')),
            ],
        ),
        migrations.AddField(
            model_name='ppapplication',
            name='form',
            field=models.ForeignKey(to='pump_priming.PPForm'),
        ),
        migrations.AddField(
            model_name='ppapplicant',
            name='application',
            field=models.ForeignKey(to='pump_priming.PPApplication'),
        ),
    ]
