from django.db import models

# Create your models here.
class PPForm(models.Model):

    name = models.CharField(max_length=100)
    slug = models.SlugField(max_length=102)
    description = models.TextField(blank=True)
    enabled = models.BooleanField(default=False)
    completed_message = models.TextField(blank=True)

    def __unicode__(self):
        return self.name

    def get_applications(self):
        return PPApplication.objects.filter(form=self)


class PPApplication(models.Model):

    form = models.ForeignKey('PPForm')
    created = models.DateTimeField(auto_now_add=True)

    title = models.CharField(max_length=10)
    forename = models.CharField(max_length=200)
    surname = models.CharField(max_length=200)
    email = models.EmailField()
    telephone = models.CharField(max_length=20)
    institution = models.CharField(max_length=200)
    address = models.TextField()

    adm_institution = models.CharField(max_length=200, verbose_name='Name')
    adm_institution_address = models.TextField(verbose_name='Address')
    title_of_study = models.CharField(max_length=200)

    abstract = models.TextField(verbose_name='Abstract and methodological description of the study', help_text='Approx 2000 Words')

    ethical_approval = models.TextField()

    institutional_approval_information = models.TextField()

    confirm_declaration = models.BooleanField(default=False, verbose_name='I agree to abide by the decision of the PSGBI committee in granting this funding')

    hod_title = models.CharField(max_length=10)
    hod_forename = models.CharField(max_length=200)
    hod_surname = models.CharField(max_length=200)
    hod_email = models.EmailField()
    hod_telephone = models.CharField(max_length=20)
    hod_institution = models.CharField(max_length=200)
    hod_address = models.TextField()

    class Meta:
        ordering = ['-created']

    def __unicode__(self):
        return "%s %s" % (self.forename, self.surname)

    def get_applicants(self):
        return PPApplicant.objects.filter(application=self)

    def get_timetable(self):
        return PPTimeTable.objects.filter(application=self)

    def get_funding(self):
        return PPFunding.objects.filter(application=self)


class PPApplicant(models.Model):

    application = models.ForeignKey('PPApplication')
    order = models.IntegerField()

    title = models.CharField(max_length=10)
    forename = models.CharField(max_length=200)
    surname = models.CharField(max_length=200)
    age = models.CharField(max_length=10)
    post_held = models.CharField(max_length=200)

    def __unicode__(self):
        return "%s %s" % (self.forename, self.surname)


class PPFunding(models.Model):

    application = models.ForeignKey('PPApplication')
    order = models.IntegerField()

    name = models.CharField(max_length=200, verbose_name='Budget Item')
    amount = models.FloatField()

    def __unicode__(self):
        return self.name

class PPTimeTable(models.Model):

    application = models.ForeignKey('PPApplication')
    order = models.IntegerField()

    name = models.CharField(max_length=200, verbose_name='Project Activity or Item')
    date = models.CharField(max_length=200)

    def __unicode__(self):
        return self.name
