#Django core bits
from django.shortcuts import render, redirect, get_object_or_404
from django.contrib.auth.decorators import login_required, permission_required
from django.http import HttpResponseRedirect, Http404, HttpResponse
from django.core.urlresolvers import reverse
from django.contrib import messages
from django.template.defaultfilters import slugify
import csv

from django.forms.formsets import formset_factory
from django.forms import modelformset_factory

from modules.core.functions import *

#Forms
from forms import *

#Models
from models import *

from modules.core.decorators import members_only


@members_only
def pp_form(request, form_slug):

    pp_form = get_object_or_404(PPForm, slug=form_slug)

    pp_application_form = PPApplicationForm()

    ApplicantFormset = modelformset_factory(PPApplicant, form=PPApplicantForm, extra=1)
    applicant_formset = ApplicantFormset(queryset=PPApplicant.objects.none(), prefix='applicant')

    TimeTableFormset = modelformset_factory(PPTimeTable, form=PPTimeTableForm, extra=1)
    timetable_formset = TimeTableFormset(queryset=PPTimeTable.objects.none(), prefix='timetable')

    FundingFormset = modelformset_factory(PPFunding, form=PPFundingForm, extra=1)
    funding_formset = FundingFormset(queryset=PPFunding.objects.none(), prefix='funding')

    if request.POST:
        pp_application_form = PPApplicationForm(request.POST)
        applicant_formset = ApplicantFormset(request.POST, queryset=PPApplicant.objects.none(), prefix='applicant')
        timetable_formset = TimeTableFormset(request.POST, queryset=PPTimeTable.objects.none(), prefix='timetable')
        funding_formset = FundingFormset(request.POST, queryset=PPFunding.objects.none(), prefix='funding')

        if pp_application_form.is_valid() and applicant_formset.is_valid() and timetable_formset.is_valid() and funding_formset.is_valid():
            pp_application = pp_application_form.save(commit=False)
            pp_application.form = pp_form
            pp_application.save()

            order = 1
            for applicant_form in applicant_formset:
                applicant = applicant_form.save(commit=False)
                applicant.order = order
                applicant.application = pp_application
                applicant.save()
                order += 1

            order = 1
            for timetable_form in timetable_formset:
                timetable = timetable_form.save(commit=False)
                timetable.order = order
                timetable.application = pp_application
                timetable.save()
                order += 1

            order = 1
            for funding_form in funding_formset:
                funding = funding_form.save(commit=False)
                funding.order = order
                funding.application = pp_application
                funding.save()
                order += 1

            return redirect('pump_priming_complete', pp_form.slug)
        else:
            messages.error(request, 'Sorry, could not complete the form, please ensure you have entered all fields correctly and try again.')

    return render(request, 'public/pump_priming/form.html', {'pp_form':pp_form, 'pp_application_form': pp_application_form, 'applicant_formset': applicant_formset, 'timetable_formset': timetable_formset, 'funding_formset': funding_formset,})


@members_only
def pp_complete(request, form_slug):

    pp_form = get_object_or_404(PPForm, slug=form_slug)

    return render(request, 'public/pump_priming/complete.html', {'pp_form':pp_form})
