# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import models, migrations


class Migration(migrations.Migration):

    dependencies = [
        ('members', '0003_auto_20150904_1057'),
    ]

    operations = [
        migrations.CreateModel(
            name='Resource',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('name', models.CharField(max_length=200)),
                ('slug', models.SlugField(unique=True)),
                ('file', models.FileField(upload_to=b'resources', blank=True)),
                ('description', models.TextField(verbose_name=b'Brief Description', blank=True)),
                ('embed_code', models.TextField(blank=True)),
                ('time', models.DateTimeField(auto_now_add=True)),
                ('author', models.CharField(max_length=100, null=True, blank=True)),
            ],
            options={
                'ordering': ('name',),
            },
        ),
        migrations.CreateModel(
            name='ResourceAdditionalField',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('name', models.CharField(max_length=100)),
                ('slug', models.CharField(max_length=100)),
                ('type', models.CharField(max_length=100, choices=[('text', 'Text Field'), ('file', 'File Field'), ('image', 'Image Field'), ('checkbox', 'Checkbox Field')])),
                ('order', models.IntegerField()),
            ],
        ),
        migrations.CreateModel(
            name='ResourceAdditionalFieldValue',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('value', models.CharField(max_length=250, null=True, blank=True)),
                ('file_value', models.FileField(max_length=250, null=True, upload_to=b'resources', blank=True)),
                ('boolean_value', models.BooleanField(default=False)),
                ('additional_field', models.ForeignKey(to='resources.ResourceAdditionalField')),
                ('resource', models.ForeignKey(to='resources.Resource')),
            ],
        ),
        migrations.CreateModel(
            name='ResourceCategory',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('name', models.CharField(max_length=50)),
                ('slug', models.SlugField(unique=True)),
                ('description', models.TextField(blank=True)),
                ('template', models.CharField(max_length=150, null=True, blank=True)),
            ],
        ),
        migrations.AddField(
            model_name='resourceadditionalfield',
            name='category',
            field=models.ForeignKey(to='resources.ResourceCategory'),
        ),
        migrations.AddField(
            model_name='resource',
            name='category',
            field=models.ForeignKey(to='resources.ResourceCategory'),
        ),
        migrations.AddField(
            model_name='resource',
            name='limit_to_member_groups',
            field=models.ManyToManyField(to='members.MemberGroup', blank=True),
        ),
        migrations.AddField(
            model_name='resource',
            name='limit_to_member_types',
            field=models.ManyToManyField(to='members.MemberType', blank=True),
        ),
    ]
