from modules.resources.models import *
from modules.pages.models import *
from modules.members.models import *

from django.template import Library

register = Library()

def get_resources(section, request):
    
    if request.user.is_authenticated():
        try:
            member = Member.objects.get(user=request.user)
            if member.expiry_date:
                if today >= member.expiry_date:
                    section_resources = PageSectionResource.objects.filter(section=section,resource__limit_to_member_types__isnull=True).order_by('order')
                else:
                    section_resources = PageSectionResource.objects.filter(Q(resource__limit_to_member_types__isnull=True) | Q(resource__limit_to_member_types=member.member_type),section=section).order_by('order')
            else:
                section_resources = PageSectionResource.objects.filter(Q(resource__limit_to_member_types__isnull=True) | Q(resource__limit_to_member_types=member.member_type),section=section).order_by('order')
        
        except:
            if request.user.is_superuser:
                section_resources = PageSectionResource.objects.filter(section=section).order_by('order')
            else:
                section_resources = PageSectionResource.objects.filter(section=section,resource__limit_to_member_types__isnull=True).order_by('order')

    else:
        section_resources = PageSectionResource.objects.filter(section=section,resource__limit_to_member_types__isnull=True).order_by('order')
        
    final_resources = []    

    for resource in section_resources:

        if resource.resource.limit_to_member_groups.all():
            if request.user.is_authenticated():
                try:
                    member = Member.objects.get(user=request.user)

                    in_groups = False
                    for group in resource.resource.limit_to_member_groups.all():
                        if member in group.members.all():
                            in_groups = True

                    if in_groups:
                        final_resources.append(resource)

                except:
                    if request.user.is_superuser:
                        final_resources.append(resource)
        else:
            final_resources.append(resource)
        
        
    return final_resources

    
register.filter(get_resources)


def resource_in_locker(resource,request):
    
    
    if request.user.is_authenticated():
        try:
            member = Member.objects.get(user=request.user)
            member_resource = MemberResource.objects.get(member=member,resource=resource)
            
            if member_resource:
                return True
        except:
            pass
            
    return False
    
register.filter(resource_in_locker)