#Django core bits
from django.shortcuts import render_to_response, get_object_or_404
from django.template import RequestContext, loader, Context
from django.contrib.auth.decorators import login_required, permission_required
from django.db.models import Q
from django.contrib.sites.models import Site
from django.conf import settings
from django.http import HttpResponseRedirect, Http404, HttpResponse
from django.core.urlresolvers import reverse
from django.contrib.auth.models import User, Group
from django.core.paginator import Paginator, InvalidPage, EmptyPage

#models
from models import Resource
from modules.members.models import *

#forms
from forms import ResourceSearch

from modules.core.decorators import *

#Others
import random,csv


#functions
def get_options():
	resources = Resource.objects.all()
	
	resource_types = [] 
	
	for resource in resources:
		type = resource.get_file_type()
		if type not in resource_types:
			resource_types.append(type)
	return resource_types

#public views

def resources_home(request):

	resource_types = get_options()
	
	filtered = False

	if request.POST:
		filter_type = request.POST['filter']
		
		if request.user.is_authenticated():
			all_resources = Resource.objects.all().order_by('name')
		else:
			all_resources = Resource.objects.filter(public=True)
			
		resources = []
			
		for resource in all_resources:
			if resource.get_file_type() == filter_type:
				resources.append(resource)	
				
		filtered = filter_type	
		
	else:
		if request.user.is_authenticated():
			resources = Resource.objects.all().order_by('name')
		else:
			resources = Resource.objects.filter(public=True)
		
	page = 1			
	paginator = Paginator(resources, 12)
	
	    
	try:
		resources = paginator.page(page)
	except (EmptyPage, InvalidPage):
		resources = paginator.page(paginator.num_pages)
		
	pages = paginator.num_pages
	
	form = ResourceSearch()

	return render_to_response('public/resources/resources.html', {'resources': resources,'form':form,'resource_types':resource_types,'filtered':filtered}, context_instance=RequestContext(request))
	
def resources_page(request,pageid):

	if request.user.is_authenticated():
		resources = Resource.objects.all().order_by('name')
	else:
		resources = Resource.objects.filter(public=True).order_by('name')
		
	try:
		page = int(pageid)
	except ValueError:
		page = 1
		
	paginator = Paginator(resources,12)
	    
	try:
		resources = paginator.page(page)
	except (EmptyPage, InvalidPage):
		resources = paginator.page(paginator.num_pages)	

	form = ResourceSearch()

	return render_to_response('public/resources/resources.html',{'resources':resources,'form':form},context_instance=RequestContext(request) )

def resources_search(request):

	if request.POST:
		if request.POST['keyword'] and request.POST['keyword'] != 'Keyword...':
			q = Resource.objects.filter(Q(name__icontains=request.POST['keyword']))
		else :
			q = Resource.objects.all()
			
		if request.user.is_authenticated():
			q1 = q
		else:
			q1 = q.filter(public=True)
			
		results = q1
					
	else:
		return  HttpResponseRedirect(reverse('resources_home'))

	return render_to_response('public/resources/search_results.html',{'resources':results},context_instance=RequestContext(request))
	
	
def resource(request,resource_slug):

	resource = get_object_or_404(Resource,slug=resource_slug)
	
	return render_to_response('public/resources/resource.html',{'resource':resource},context_instance=RequestContext(request))
	
@members_only
def add_to_locker(request,resource_slug):
    
    member = get_object_or_404(Member,user=request.user)
    resource = get_object_or_404(Resource,slug=resource_slug)
    
    try:
        member_resource = MemberResource(resource=resource,member=member)
        member_resource.save()
        
        return HttpResponse('Ok')
        
    except:
        raise Http404
    
    
