from modules.notifications.models import EmailTemplate, send_mail


def travel_grant_complete_email(request, application):

    # member
    template = EmailTemplate.objects.get(key="travel_grant_completed")
    message = template.content % (application.form)
    send_mail(template.key, template.subject, message, template.from_address.email_address, application.email)

    # admin
    admin_template = EmailTemplate.objects.get(key="admin_travel_grant_completed")
    message = admin_template.content % (application.forename, application.surname, application.form, application.email, application.telephone, application.institution)
    send_mail(admin_template.key, admin_template.subject, message, admin_template.from_address.email_address, admin_template.get_to_addresses())
