from django.db import models


# Create your models here.
class TGForm(models.Model):

    name = models.CharField(max_length=100)
    slug = models.SlugField(max_length=102)
    description = models.TextField(blank=True)
    enabled = models.BooleanField(default=False)
    completed_message = models.TextField(blank=True)

    def __unicode__(self):
        return self.name

    def get_applications(self):
        return TGApplication.objects.filter(form=self)


class TGApplication(models.Model):

    form = models.ForeignKey('TGForm')
    created = models.DateTimeField(auto_now_add=True)

    title = models.CharField(max_length=10)
    forename = models.CharField(max_length=200)
    surname = models.CharField(max_length=200)
    email = models.EmailField()
    telephone = models.CharField(max_length=20)
    institution = models.CharField(max_length=200)
    address = models.TextField()

    abstract = models.TextField(verbose_name='Abstract and methodological description of the study', help_text='Maxiumum 400 Words')
    intended_date = models.DateField(verbose_name='Intended Date of Activity')

    objective = models.TextField()

    confirm_declaration = models.BooleanField(default=False, verbose_name='I agree to abide by the terms of the grant funding and the decision of the PSGB&I committee')

    class Meta:
        ordering = ['-created']

    def __unicode__(self):
        return "%s %s" % (self.forename, self.surname)

    def get_contributors(self):
        return TGContributor.objects.filter(application=self)


class TGContributor(models.Model):

    application = models.ForeignKey('TGApplication')
    order = models.IntegerField()

    title = models.CharField(max_length=10)
    forename = models.CharField(max_length=200)
    surname = models.CharField(max_length=200)
    age = models.CharField(max_length=10)
    post_held = models.CharField(max_length=200)

    def __unicode__(self):
        return "%s %s" % (self.forename, self.surname)

