from django.conf.urls import patterns, include, url
from django.contrib.auth.views import logout
from django.conf import settings

from django.views.generic import RedirectView

from django.contrib import admin
admin.autodiscover()

urlpatterns = patterns('',

    url(r'^$','modules.core.views.home',name='home'),

    #general website
    url(r'^mediacentre/',include('modules.mediacentre.urls')),
    url(r'^contact-us/$','modules.contact.views.contact', name="contact"),

    url(r'^search/$','modules.core.views.search',name="search"),
    url(r'^sitemap/$','modules.core.views.sitemap',name="sitemap"),
    url(r'^sitemap\.xml$','modules.core.views.sitemap_xml',name="sitemap_xml"),

    url(r'^register/',include('modules.members.registrationurls')),
    url(r'^meeting-booking/',include('modules.meeting_booking.urls')),
    url(r'^abstracts/', include('modules.abstracts.urls')),
    url(r'^elections/',include('modules.elections.urls')),
    url(r'^donate/',include('modules.donations.urls')),
    url(r'^pump-priming/',include('modules.pump_priming.urls')),
    url(r'^travel-grants/',include('modules.travel_grants.urls')),

    url(r'^certificate/$', 'modules.certificates.views.certificate', name='certificate'),

    #login and forgot pass
    url(r'^login/$',  'modules.core.views.login_view', name='login'),
    url(r'^logout/$', logout, {'template_name': 'public/login/logout.html'},name="logout"),

    url(r'^forgot-password/$', 'modules.core.views.forgot_password', name='forgot_password'),
    url(r'^forgot-password/(?P<forgot_key>[-\w]+)/$', 'modules.core.views.forgot_password_confirm', name='forgot_password_confirm'),

    url(r'^my-locker/',include('modules.members.accounturls')),

    #member check
    url(r'^check-members/(?P<key>[-\w]+)/$', 'modules.members.checkviews.check_members', name='check_members'),
    url(r'^renew-members/(?P<key>[-\w]+)/$', 'modules.members.checkviews.renew_members', name='renew_members'),

    url(r'^member-required/$','modules.core.views.member_required',name='member_required'),
    url(r'^member-expired/$','modules.core.views.member_expired',name='member_expired'),
    url(r'^disabled/$','modules.core.views.member_disabled',name='member_disabled'),
    url(r'^not-approved/$','modules.core.views.member_notapproved',name='member_notapproved'),

    url(r'^dadmin/', include(admin.site.urls)),
    url(r'^admin/', include('modules.core.adminurls')),
    url(r'^impersonate/', include('impersonate.urls')),

    #paypal
    url(r'^paypal-notify/r4g7rg73wtg78gf7fg78cgf78eg7g78e/', include('paypal.standard.ipn.urls')),

)

if settings.DEVELOPMENT:
    urlpatterns += patterns('',
        url(r'^media/(?P<path>.*)$', 'django.views.static.serve', {
            'document_root': settings.MEDIA_ROOT
        }),
    )

urlpatterns += patterns('',
    url(r'(?P<address>[-\w/]+)$','modules.pages.views.page',name='page'),
)
