#Django core bits
from django.shortcuts import render_to_response, get_object_or_404
from django.template import RequestContext, loader, Context
from django.contrib.auth.decorators import login_required, permission_required
from django.conf import settings
from django.http import HttpResponseRedirect, Http404, HttpResponse
from django.core.urlresolvers import reverse
from django.contrib.auth.models import User, Group
from django.core.mail import EmailMessage
from django.contrib import messages
from datetime import datetime,date,time
from django.views.decorators.csrf import csrf_exempt

from dateutil.relativedelta import relativedelta
from calendar import *
#Others
import random,csv,string

import pdfcrowd

#Forms
from forms import *

#Models
from models import *
from modules.members.models import *
from modules.payments.models import *

from modules.core.functions import *
from modules.core.decorators import *
from modules.payments.functions import *

import emails

@members_only
def submissions(request):

    member = get_object_or_404(Member,user=request.user)
    abstract_submissions = AbstractSubmission.objects.filter(member=member,complete=True).order_by('-created')

    return render(request,'members/abstracts/submissions/submissions.html',{'abstract_submissions':abstract_submissions})


@members_only
def view_submission(request,submission_id):

    member = get_object_or_404(Member,user=request.user)
    abstract_submission = get_object_or_404(AbstractSubmission,id=submission_id,member=member,complete=True)

    return render(request,'members/abstracts/submissions/view-submission.html',{'abstract_submission':abstract_submission})

"""""""""""""""""""""""""""
""""""""""REVIEWS""""""""""
"""""""""""""""""""""""""""

@members_only
def review_content_requests(request):

    member = get_object_or_404(Member,user=request.user)
    content_reviews = AbstractSubmissionReview.objects.filter(reviewer=member,sent=True).order_by('-created')

    abstract_requests = []

    for content_review in content_reviews:
        if content_review.content_submission.abstract_request not in abstract_requests:
            abstract_requests.append(content_review.content_submission.abstract_request)

    final_requests = []
    for abstract_request in abstract_requests:
        final_requests.append({'abstract_request':abstract_request,'outstanding_reviews':abstract_request.get_outstanding_reviews(member).count()})

    return render_to_response('members/abstracts/all-requests.html',{'requests':final_requests},context_instance=RequestContext(request))


@members_only
def review_content_requests_abstract_request(request,abstract_request_slug):

    member = get_object_or_404(Member,user=request.user)
    abstract_request = get_object_or_404(AbstractRequest,slug=abstract_request_slug)

    abstract_reviews = AbstractSubmissionReview.objects.filter(reviewer=member,content_submission__abstract_request=abstract_request,sent=True)

    review_activity = UserActivity.objects.filter(type='abstract-request-notification',member=member)
    for activity in review_activity:
        activity.read = True
        activity.save()

    return render_to_response('members/abstracts/requests.html',{'abstract_request':abstract_request,'abstract_reviews':abstract_reviews},context_instance=RequestContext(request))

@members_only
def review_content_requests_download(request,abstract_request_slug):

    member = get_object_or_404(Member,user=request.user)
    abstract_request = get_object_or_404(AbstractRequest,slug=abstract_request_slug)

    abstract_reviews = AbstractSubmissionReview.objects.filter(reviewer=member,content_submission__abstract_request=abstract_request,sent=True)

    #return render(request,'members/abstracts/download-requests.html',{'abstract_request':abstract_request,'abstract_reviews':abstract_reviews})

    html = loader.render_to_string('members/abstracts/download-requests.html',{'abstract_request':abstract_request,'abstract_reviews':abstract_reviews},context_instance=RequestContext(request))

    client = pdfcrowd.Client("calmdigital", "dc33e7c4525620565185d0a00d90b8f0")
    client.setPageMargins('50','50','0','50')

    pdf = client.convertHtml(html)

     # set HTTP response headers
    response = HttpResponse(content_type="application/pdf")
    response["Cache-Control"] = "no-cache"
    response["Accept-Ranges"] = "none"
    response["Content-Disposition"] = "attachment; filename=content_requests.pdf"

    response.write(pdf)

    return response


@members_only
def review_content_request(request,abstract_request_slug,review_id):

    member = get_object_or_404(Member,user=request.user)
    abstract_request = get_object_or_404(AbstractRequest,slug=abstract_request_slug)
    content_review = get_object_or_404(AbstractSubmissionReview,reviewer=member,id=review_id,sent=True)

    review_activity = UserActivity.objects.filter(type='meeting-content-notification',member=member)

    for activity in review_activity:
        activity.read = True
        activity.save()

    if content_review.reviewed:
        return render_to_response('members/abstracts/request-already-reviewed.html',{'abstract_request':abstract_request,'content_review':content_review},context_instance=RequestContext(request))

    content_submission = content_review.content_submission

    content_submission_review_form = AbstractSubmissionReviewForm(instance=content_review,initial={'scorer_name':'%s %s' % (member.given_name,member.surname)})
    content_submission_evaluation_form = AbstractSubmissionReviewEvaluationForm(instance=content_review)

    additional_forms = []

    scoring_fields = [{'name':'Title','slug':'title_score'},{'name':'Construction','slug':'abstract_construction'},{'name':'Study Content and Conclusions','slug':'content_score'},{'name':'Relevance','slug':'relevance_score'},{'name':'Priority','slug':'priority_score'}]

    scoring_errors = []

    if request.POST:
        if request.POST.get('reject'):
            content_submission_evaluation_form = AbstractSubmissionReviewForm(request.POST,instance=content_review)

            if content_submission_evaluation_form.is_valid():

                content_review.rejected = True
                content_review.reviewed = True
                now = datetime.now()
                content_review.review_created = now
                content_review.save()

                #signal here
                emails.abstract_content_review_rejected(request=request,content_submission_review=content_review)

                return HttpResponseRedirect(reverse('review_content_request_rejected',args=[meeting_content.slug,review_id]))

        content_submission_evaluation_form = AbstractSubmissionReviewEvaluationForm(request.POST,instance=content_review)

        for field in scoring_fields:
            if not request.POST.get('field_%s' % (field['slug'])):
                scoring_errors.append('Please enter a score for %s' % (field['name']))
            else:
                field['value'] = request.POST['field_%s' % (field['slug'])]

        if content_submission_evaluation_form.is_valid():

            if not scoring_errors:

                content_submission_evaluation_form.save()

                content_review.title_score = request.POST['field_title_score']
                content_review.abstract_construction = request.POST['field_abstract_construction']
                content_review.content_score = request.POST['field_content_score']
                content_review.relevance_score = request.POST['field_relevance_score']
                content_review.priority_score = request.POST['field_priority_score']
                content_review.save()

                content_review.reviewed = True
                now = datetime.now()
                content_review.review_created = now
                content_review.save()

                #signal here
                emails.abstract_content_review_completed(request=request,content_submission_review=content_review)

                return HttpResponseRedirect(reverse('review_content_request_complete',args=[abstract_request.slug,review_id]))

    return render_to_response('members/abstracts/submit-review.html',{'abstract_request':abstract_request,'content_review':content_review,'content_submission':content_submission,'content_submission_evaluation_form':content_submission_evaluation_form,'scoring_fields':scoring_fields,'scoring_errors':scoring_errors},context_instance=RequestContext(request))

@members_only
def review_content_request_complete(request,abstract_request_slug,review_id):

    member = get_object_or_404(Member,user=request.user)
    abstract_request = get_object_or_404(AbstractRequest,slug=abstract_request_slug)
    content_review = get_object_or_404(AbstractSubmissionReview,reviewer=member,id=review_id,sent=True)

    next_review = content_review.get_next()
    abstract_reviews = AbstractSubmissionReview.objects.filter(reviewer=member,content_submission__abstract_request=abstract_request,sent=True)

    return render(request,'members/abstracts/request-completed.html',{'abstract_request':abstract_request,'content_review':content_review,'next_review':next_review,'abstract_reviews':abstract_reviews})

@members_only
def review_content_request_rejected(request,abstract_request_slug,review_id):

    member = get_object_or_404(Member,user=request.user)
    abstract_request = get_object_or_404(AbstractRequest,slug=abstract_request_slug)
    content_review = get_object_or_404(AbstractSubmissionReview,reviewer=member,id=review_id,sent=True)

    if not content_review.reviewed:
        return HttpResponseRedirect(reverse('review_content_request',args=[review_id]))
    else:
        return render_to_response('members/abstracts/request-rejected.html',{'abstract_request':abstract_request,'content_review':content_review},context_instance=RequestContext(request))
