from models import *
from modules.notifications.models import *

def abstract_content_saved(request,content_submission):

    try:
        template = EmailTemplate.objects.get(key='abstract_content_submission_saved')
        resume_url = reverse('abstract_submission_resume',args=[content_submission.abstract_request.slug,content_submission.unique_key])

        message = template.content % (content_submission.given_name,content_submission.surname,content_submission.abstract_request,request.META['HTTP_HOST'],resume_url,request.META['HTTP_HOST'],resume_url)
        subject = template.subject

        send_mail(template.key,subject,message,template.from_address.email_address,content_submission.email)

    except Exception, e:
        raise e

def abstract_content_submitted(request,content_submission):

    try:
        template = EmailTemplate.objects.get(key='abstract_content_submission_submitted')

        message = template.content % (content_submission.given_name,content_submission.surname,content_submission.abstract_request,content_submission.unique_code)
        subject = template.subject

        send_mail(template.key,subject,message,template.from_address.email_address,content_submission.email)
    except Exception, e:
        raise e

    #admin email
    try:
        template = EmailTemplate.objects.get(key='abstract_content_submission_admin')
        message = template.content % (content_submission.given_name,content_submission.surname,content_submission.email,content_submission.content_type,content_submission.abstract_request,content_submission.unique_code,request.META['HTTP_HOST'],reverse('admin_abstracts_view_submission',args=[content_submission.abstract_request.id,content_submission.id]))
        subject = template.subject

        send_mail(template.key,subject,message,template.from_address.email_address,template.get_to_addresses())
    except Exception, e:
        raise e


def abstract_content_review_requested_multiple(request,content_submission_review):

    content_submission = content_submission_review.content_submission

    #user email
    try:
        template = EmailTemplate.objects.get(key='abstract_content_review_requested_multiple')
        message = template.content % (content_submission.abstract_request,request.META['HTTP_HOST'],request.META['HTTP_HOST'])
        subject = template.subject

        send_mail(template.key,subject,message,template.from_address.email_address,content_submission_review.reviewer.user.email)
    except Exception, e:
        raise e


def abstract_content_review_requested(request,content_submission_review):

    content_submission = content_submission_review.content_submission

    #user email
    try:
        template = EmailTemplate.objects.get(key='abstract_content_review_requested')
        message = template.content % (content_submission.unique_code,content_submission.abstract_request)
        subject = template.subject

        send_mail(template.key,subject,message,template.from_address.email_address,content_submission_review.reviewer.user.email)
    except Exception, e:
        raise e

def abstract_content_review_completed(request,content_submission_review):

    content_submission = content_submission_review.content_submission

    #user email
    try:
        template = EmailTemplate.objects.get(key='abstract_content_review_completed')
        message = template.content % (content_submission_review.reviewer.given_name,content_submission_review.reviewer.surname,content_submission.given_name,content_submission.surname,content_submission.abstract_request,content_submission.unique_code,request.META['HTTP_HOST'],reverse('admin_abstracts_view_submission_review',args=[content_submission.abstract_request.id,content_submission.id,content_submission_review.id]))
        subject = template.subject

        send_mail(template.key,subject,message,template.from_address.email_address,template.get_to_addresses())
    except Exception, e:
        raise e


def abstract_content_review_rejected(request,content_submission_review):

    content_submission = content_submission_review.content_submission

    #user email
    try:
        template = EmailTemplate.objects.get(key='abstract_content_review_rejected')
        message = template.content % (content_submission_review.reviewer.given_name,content_submission_review.reviewer.surname,content_submission.given_name,content_submission.surname,content_submission.abstract_request,content_submission.unique_code,request.META['HTTP_HOST'],reverse('admin_abstracts_view_submission_review',args=[content_submission.abstract_request.id,content_submission.id,content_submission_review.id]))
        subject = template.subject

        send_mail(template.key,subject,message,template.from_address.email_address,template.get_to_addresses())
    except Exception, e:
        raise e


def abstract_content_submission_approved(request,content_submission):

    try:
        template = EmailTemplate.objects.get(key='abstract_content_submission_approved')
        message = template.content % (content_submission.given_name,content_submission.surname,content_submission.get_title(),content_submission.abstract_request.name)
        subject = template.subject

        send_mail(template.key,subject,message,template.from_address.email_address,content_submission.email)

    except Exception, e:
        raise e

def abstract_content_submission_rejected(request,content_submission):

    try:
        template = EmailTemplate.objects.get(key='abstract_content_submission_rejected')
        message = template.content % (content_submission.given_name,content_submission.surname,content_submission.get_title(),content_submission.abstract_request.name)
        send_mail(template.key,template.subject,message,template.from_address.email_address,content_submission.email)
    except Exception, e:
        raise e
