from django.conf.urls import *

urlpatterns = patterns('',

    url(r'^homepage-content/$','modules.blocks.adminviews.homepage_content',name='admin_blocks_homepage_content'),
    
    url(r'^homepage-blocks/$','modules.blocks.adminviews.homepage_blocks',name='admin_blocks_homepage_blocks'),
    url(r'^homepage-blocks/layout/$','modules.blocks.adminviews.homepage_blocks_layout',name='admin_blocks_homepage_blocks_layout'),
    url(r'^homepage-blocks/layout/(?P<layout_id>[-\d]+)/$','modules.blocks.adminviews.homepage_blocks_layout_load',name='admin_blocks_homepage_blocks_layout_load'),
    url(r'^homepage-blocks/layout/(?P<layout_id>[-\d]+)/save/$','modules.blocks.adminviews.homepage_blocks_layout_save',name='admin_blocks_homepage_blocks_layout_save'),
    
    url(r'^homepage-blocks/add/$','modules.blocks.adminviews.add_block',name='admin_blocks_add_block'),
    url(r'^homepage-blocks/edit/(?P<block_id>[-\d]+)$','modules.blocks.adminviews.edit_block',name='admin_blocks_edit_block'),
    url(r'^homepage-blocks/delete/(?P<block_id>[-\d]+)$','modules.blocks.adminviews.delete_block',name='admin_blocks_delete_block'),
    
    url(r'^homepage-blocks/(?P<block_id>[-\d]+)/banners/$','modules.blocks.adminviews.block_banners',name='admin_blocks_block_banners'),
    url(r'^homepage-blocks/(?P<block_id>[-\d]+)/banners/add/$','modules.blocks.adminviews.block_banners_add',name='admin_blocks_add_banner'),
    url(r'^homepage-blocks/(?P<block_id>[-\d]+)/banners/edit/(?P<banner_id>[-\d]+)/$','modules.blocks.adminviews.block_banners_edit',name='admin_blocks_edit_banner'),
    url(r'^homepage-blocks/(?P<block_id>[-\d]+)/banners/delete/(?P<banner_id>[-\d]+)/$','modules.blocks.adminviews.block_banners_delete',name='admin_blocks_delete_banner'),
    
    url(r'^menu/$', 'modules.blocks.adminviews.menus', name='admin_blocks_menus'),
    url(r'^menu/(?P<menu_slug>[-\w]+)/$', 'modules.blocks.adminviews.menu_items', name='admin_blocks_menu_items'),
    url(r'^menu/(?P<menu_slug>[-\w]+)/add/$','modules.blocks.adminviews.add_menu_item',name='admin_blocks_add_menu_item'),
    url(r'^menu/(?P<menu_slug>[-\w]+)/edit/(?P<item_id>[-\d]+)$','modules.blocks.adminviews.edit_menu_item',name='admin_blocks_edit_menu_item'),
    url(r'^menu/(?P<menu_slug>[-\w]+)/delete/(?P<item_id>[-\d]+)$','modules.blocks.adminviews.delete_menu_item',name='admin_blocks_delete_menu_item'),
    url(r'^menu/(?P<menu_slug>[-\w]+)/reorder/$','modules.blocks.adminviews.reorder_menu_items',name='admin_blocks_reorder_menu_items'),
    
    url(r'^content-blocks/$','modules.blocks.adminviews.content_blocks', name='admin_blocks_content_blocks'),
    url(r'^content-blocks/(?P<block_id>[-\d]+)/edit/$','modules.blocks.adminviews.edit_content_block', name='admin_blocks_edit_content_block'),
    
    url(r'^homepage-search/$','modules.blocks.adminviews.homepage_search',name='admin_blocks_homepage_search'),
    url(r'^homepage-search/add/$','modules.blocks.adminviews.add_homepage_search',name='admin_blocks_add_homepage_search'),
    url(r'^homepage-search/(?P<search_id>[-\d]+)/edit/$','modules.blocks.adminviews.edit_homepage_search',name='admin_blocks_edit_homepage_search'),
    url(r'^homepage-search/(?P<search_id>[-\d]+)/delete/$','modules.blocks.adminviews.delete_homepage_search',name='admin_blocks_delete_homepage_search'),
    
)